/*
 * Decompiled with CFR 0.152.
 */
package com.radiantminds.roadmap.common.rest.services.resources;

import com.radiantminds.roadmap.common.data.entities.people.IAvailability;
import com.radiantminds.roadmap.common.data.persistence.common.entitypersistence.PortfolioAvailabilityIntervalPersistence;
import com.radiantminds.roadmap.common.handlers.SecuredInvocationHandlerFactory;
import com.radiantminds.roadmap.common.rest.entities.people.RestAvailability;
import com.radiantminds.roadmap.common.rest.services.common.BaseOperationsService;
import javax.ws.rs.Path;
import javax.ws.rs.core.Response;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Path(value="/availabilities")
@Component
public class AvailabilityIntervalService
extends BaseOperationsService<IAvailability, RestAvailability> {
    @Autowired
    public AvailabilityIntervalService(SecuredInvocationHandlerFactory handlerFactory, PortfolioAvailabilityIntervalPersistence availabilityIntervalPersistence) {
        super(RestAvailability.class, availabilityIntervalPersistence, handlerFactory);
    }

    @Override
    protected RestAvailability transform(IAvailability entity, boolean includeReplanningData) {
        return new RestAvailability(entity);
    }

    @Override
    protected Response update(RestAvailability source, IAvailability target, boolean allowNull) {
        Number val;
        this.updateCommons(source, target, allowNull);
        if (allowNull || source.getAvailability() != null) {
            val = source.getAvailability();
            if (val == null || (Double)val == -1.0) {
                val = null;
            }
            target.setAvailability((Double)val);
        }
        if (allowNull || source.getStartDate() != null) {
            val = source.getStartDate();
            if (val == null || (Long)val == -1L) {
                val = null;
            }
            target.setStartDate((Long)val);
        }
        if (allowNull || source.getEndDate() != null) {
            val = source.getEndDate();
            if (val == null || (Long)val == -1L) {
                val = null;
            }
            target.setEndDate((Long)val);
        }
        return null;
    }
}

