/*
 * Decompiled with CFR 0.152.
 */
package com.radiantminds.roadmap.common.rest.services.teams;

import com.radiantminds.roadmap.common.data.activeobjects.ActiveObjectsUtilities;
import com.radiantminds.roadmap.common.data.persistence.common.entitypersistence.PortfolioTeamPersistence;
import com.radiantminds.roadmap.common.data.persistence.common.entitypersistence.PortfolioWorkItemPersistence;
import com.radiantminds.roadmap.common.data.persistence.services.PortfolioPlanPersistence;
import com.radiantminds.roadmap.common.handlers.EntityContext;
import com.radiantminds.roadmap.common.handlers.SecuredInvocationHandlerFactory;
import com.radiantminds.roadmap.common.rest.entities.common.RestRank;
import com.radiantminds.roadmap.common.rest.entities.people.RestTeam;
import com.radiantminds.roadmap.common.rest.services.teams.PlanTeamServiceHandler;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Consumes(value={"application/json"})
@Produces(value={"application/json", "application/xml"})
@Path(value="/plans/{id}/teams")
@Component
public class PlanTeamService {
    private final PlanTeamServiceHandler handler;

    @Autowired
    public PlanTeamService(SecuredInvocationHandlerFactory handlerFactory, ActiveObjectsUtilities activeObjectsUtilities, PortfolioPlanPersistence planPersistence, PortfolioWorkItemPersistence workItemPersistence, PortfolioTeamPersistence teamPersistence) {
        this.handler = handlerFactory.createProxy(PlanTeamServiceHandler.class, new PlanTeamServiceHandler.Impl(activeObjectsUtilities, teamPersistence, workItemPersistence), planPersistence);
    }

    @GET
    public Response getAllTeams(@PathParam(value="id") String planId, @QueryParam(value="planVersion") Long expectedPlanVersion) throws Exception {
        return this.handler.getAllTeams(EntityContext.from(planId, expectedPlanVersion));
    }

    @POST
    public Response addTeamToPlan(@PathParam(value="id") String planId, @QueryParam(value="planVersion") Long expectedPlanVersion, @QueryParam(value="clientId") String clientId, RestTeam newTeam) throws Exception {
        return this.handler.addTeamToPlan(EntityContext.from(planId, expectedPlanVersion, clientId), newTeam);
    }

    @PUT
    @Path(value="/rank")
    public Response rankTeam(@PathParam(value="id") String planId, @QueryParam(value="planVersion") Long expectedPlanVersion, @QueryParam(value="clientId") String clientId, RestRank rank) throws Exception {
        return this.handler.rankTeam(EntityContext.from(planId, expectedPlanVersion, clientId), rank);
    }
}

