/*
 * Decompiled with CFR 0.152.
 */
package com.radiantminds.roadmap.common.rest.services.themes;

import com.google.common.collect.Iterables;
import com.radiantminds.roadmap.common.data.activeobjects.ActiveObjectsUtilities;
import com.radiantminds.roadmap.common.data.entities.plans.IPlan;
import com.radiantminds.roadmap.common.data.entities.themes.ITheme;
import com.radiantminds.roadmap.common.data.persistence.ao.entities.themes.AOTheme;
import com.radiantminds.roadmap.common.data.persistence.common.entitypersistence.PortfolioThemePersistence;
import com.radiantminds.roadmap.common.data.persistence.common.entitypersistence.PortfolioWorkItemPersistence;
import com.radiantminds.roadmap.common.handlers.EntityContext;
import com.radiantminds.roadmap.common.handlers.VersionIncrementMode;
import com.radiantminds.roadmap.common.handlers.annotations.AuthorizedPlanReadAccess;
import com.radiantminds.roadmap.common.handlers.annotations.AuthorizedPlanUserAccess;
import com.radiantminds.roadmap.common.rest.common.SubCollectionUtils;
import com.radiantminds.roadmap.common.rest.common.SubCollectionUtilsCallback;
import com.radiantminds.roadmap.common.rest.common.ToRest;
import com.radiantminds.roadmap.common.rest.entities.common.ModificationResult;
import com.radiantminds.roadmap.common.rest.entities.common.RestRank;
import com.radiantminds.roadmap.common.rest.entities.themes.RestTheme;
import com.radiantminds.roadmap.common.rest.utils.IPercentableCallback;
import com.radiantminds.roadmap.common.rest.utils.PercentageUtils;
import java.util.List;
import javax.ws.rs.core.Response;

public interface PlanThemeServiceHandler {
    @AuthorizedPlanReadAccess
    public Response getAllThemes(EntityContext<IPlan> var1) throws Exception;

    @AuthorizedPlanUserAccess(entityNeeded=true, incrementPlanVersion=VersionIncrementMode.On, incrementEntityVersion=VersionIncrementMode.Off)
    public Response addThemeToPlan(EntityContext<IPlan> var1, RestTheme var2) throws Exception;

    @AuthorizedPlanUserAccess(incrementEntityVersion=VersionIncrementMode.Off, incrementPlanVersion=VersionIncrementMode.On, incrementSchedulingVersion=VersionIncrementMode.Off)
    public Response rankTheme(EntityContext<IPlan> var1, RestRank var2) throws Exception;

    public static class Impl
    implements PlanThemeServiceHandler {
        private final PortfolioThemePersistence themePersistence;
        private final SubCollectionUtils subCollectionUtils;

        public Impl(ActiveObjectsUtilities activeObjectsUtilities, PortfolioThemePersistence themePersistence, PortfolioWorkItemPersistence workItemPersistence) {
            this.themePersistence = themePersistence;
            this.subCollectionUtils = new SubCollectionUtils(activeObjectsUtilities, workItemPersistence);
        }

        @Override
        public Response getAllThemes(EntityContext<IPlan> entityContext) throws Exception {
            List<ITheme> themes = this.themePersistence.listCustom(entityContext.getEntityId());
            return entityContext.okForList(Iterables.toArray(ToRest.transferList(RestTheme.class, ITheme.class, themes), RestTheme.class));
        }

        @Override
        public Response addThemeToPlan(EntityContext<IPlan> entityContext, RestTheme newTheme) throws Exception {
            return this.subCollectionUtils.handleAddEntityToCollection(entityContext, AOTheme.class, "plan", newTheme, new SubCollectionUtilsCallback.Adapter<IPlan, ITheme, RestTheme>(){
                private ModificationResult persistResult = null;

                @Override
                public void setParent(IPlan parent, ITheme entity) {
                    entity.setPlan(parent);
                }

                @Override
                public ITheme persist(ITheme entity) throws Exception {
                    ITheme theme = themePersistence.persist(entity);
                    this.persistResult = PercentageUtils.adaptToItemAdd(theme.getPlan(), theme, IPercentableCallback.THEME, themePersistence);
                    return theme;
                }

                @Override
                public ITheme get(String id) throws Exception {
                    return (ITheme)themePersistence.get(id);
                }

                @Override
                public ModificationResult buildModificationResult(ITheme stored) throws Exception {
                    return this.persistResult;
                }
            });
        }

        @Override
        public Response rankTheme(EntityContext<IPlan> planContext, RestRank rank) throws Exception {
            return this.subCollectionUtils.rankEntity(planContext, AOTheme.class, this.themePersistence, "plan", rank);
        }
    }
}

