/*
 * Decompiled with CFR 0.152.
 */
package com.radiantminds.roadmap.common.rest.services.workitems;

import com.google.common.base.Optional;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.radiantminds.roadmap.common.data.activeobjects.ActiveObjectsUtilities;
import com.radiantminds.roadmap.common.data.entities.plans.IPlan;
import com.radiantminds.roadmap.common.data.entities.plans.IPlanConfiguration;
import com.radiantminds.roadmap.common.data.entities.workitems.IWorkItem;
import com.radiantminds.roadmap.common.data.entities.workitems.WorkItems;
import com.radiantminds.roadmap.common.data.persistence.PersistenceException;
import com.radiantminds.roadmap.common.data.persistence.ao.entities.workitems.workitem.AOWorkItem;
import com.radiantminds.roadmap.common.data.persistence.common.entitypersistence.PortfolioEstimatePersistence;
import com.radiantminds.roadmap.common.data.persistence.common.entitypersistence.PortfolioExtensionLinkPersistence;
import com.radiantminds.roadmap.common.data.persistence.common.entitypersistence.PortfolioReleasePersistence;
import com.radiantminds.roadmap.common.data.persistence.common.entitypersistence.PortfolioStagePersistence;
import com.radiantminds.roadmap.common.data.persistence.common.entitypersistence.PortfolioTeamPersistence;
import com.radiantminds.roadmap.common.data.persistence.common.entitypersistence.PortfolioWorkItemPersistence;
import com.radiantminds.roadmap.common.data.persistence.services.PortfolioPlanPersistence;
import com.radiantminds.roadmap.common.extensions.issues.IssueSyncData;
import com.radiantminds.roadmap.common.extensions.issues.PortfolioToJiraSyncExtension;
import com.radiantminds.roadmap.common.extensions.workitems.ProgressConfigurationPlanConfigWrapper;
import com.radiantminds.roadmap.common.filter.WorkItemSolutionFilter;
import com.radiantminds.roadmap.common.filter.WorkItemSolutionFilterResult;
import com.radiantminds.roadmap.common.handlers.EntityContext;
import com.radiantminds.roadmap.common.handlers.VersionIncrementMode;
import com.radiantminds.roadmap.common.handlers.annotations.AuthorizedPlanReadAccess;
import com.radiantminds.roadmap.common.handlers.annotations.AuthorizedPlanUserAccess;
import com.radiantminds.roadmap.common.rest.common.ResponseBuilder;
import com.radiantminds.roadmap.common.rest.common.SubCollectionUtils;
import com.radiantminds.roadmap.common.rest.common.SubCollectionUtilsCallback;
import com.radiantminds.roadmap.common.rest.common.ToRest;
import com.radiantminds.roadmap.common.rest.entities.common.RestIdList;
import com.radiantminds.roadmap.common.rest.entities.common.RestRank;
import com.radiantminds.roadmap.common.rest.entities.common.messaging.RestMessaging;
import com.radiantminds.roadmap.common.rest.entities.filter.RestWorkItemFilter;
import com.radiantminds.roadmap.common.rest.entities.progress.RestProgressConfiguration;
import com.radiantminds.roadmap.common.rest.entities.workitems.RestWorkItem;
import com.radiantminds.roadmap.common.rest.entities.workitems.RestWorkItemFilterResult;
import com.radiantminds.roadmap.common.rest.services.workitems.WorkItemUtils;
import com.radiantminds.roadmap.common.rest.services.workitems.constraints.WorkItemConstraintChecker;
import com.radiantminds.roadmap.common.rest.services.workitems.constraints.WorkItemConstraintException;
import com.radiantminds.roadmap.common.scheduling.Scheduling;
import com.radiantminds.roadmap.common.stats.MonitoredCallResult;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.ws.rs.core.Response;

public interface PlanWorkItemServiceHandler {
    @AuthorizedPlanReadAccess
    public Response getSpecificWorkItemsWithPost(EntityContext<IPlan> var1, boolean var2, RestIdList var3) throws Exception;

    @AuthorizedPlanReadAccess
    public Response getFiltered(EntityContext<IPlan> var1, boolean var2, boolean var3, RestWorkItemFilter var4) throws Exception;

    @AuthorizedPlanReadAccess
    public Response getAll(EntityContext<IPlan> var1, boolean var2, boolean var3) throws Exception;

    @AuthorizedPlanUserAccess(entityNeeded=true, incrementEntityVersion=VersionIncrementMode.Off, incrementPlanVersion=VersionIncrementMode.On)
    public Response addToPlan(EntityContext<IPlan> var1, RestWorkItem var2) throws Exception;

    @AuthorizedPlanUserAccess(incrementEntityVersion=VersionIncrementMode.Off, incrementPlanVersion=VersionIncrementMode.On)
    public Response rank(EntityContext<IPlan> var1, RestRank var2) throws Exception;

    public static class Impl
    implements PlanWorkItemServiceHandler {
        private final PortfolioPlanPersistence planPersistence;
        private final PortfolioWorkItemPersistence workItemPersistence;
        private final PortfolioReleasePersistence releasePersistence;
        private final PortfolioTeamPersistence teamPersistence;
        private final PortfolioStagePersistence stagePersistence;
        private final WorkItemUtils workItemPersister;
        private final SubCollectionUtils subCollectionUtils;
        private final WorkItemConstraintChecker workItemConstraintChecker;
        private final PortfolioToJiraSyncExtension portfolioToJiraSyncExtension;
        private final Scheduling scheduling;

        public Impl(ActiveObjectsUtilities activeObjectsUtilities, PortfolioPlanPersistence planPersistence, PortfolioWorkItemPersistence workItemPersistence, PortfolioEstimatePersistence estimatePersistence, PortfolioExtensionLinkPersistence extensionLinkPersistence, PortfolioReleasePersistence releasePersistence, PortfolioTeamPersistence teamPersistence, PortfolioStagePersistence stagePersistence, PortfolioToJiraSyncExtension portfolioToJiraSyncExtension, Scheduling scheduling) {
            this.planPersistence = planPersistence;
            this.workItemPersistence = workItemPersistence;
            this.releasePersistence = releasePersistence;
            this.teamPersistence = teamPersistence;
            this.stagePersistence = stagePersistence;
            this.portfolioToJiraSyncExtension = portfolioToJiraSyncExtension;
            this.scheduling = scheduling;
            this.workItemPersister = new WorkItemUtils(this.workItemPersistence, estimatePersistence, extensionLinkPersistence);
            this.subCollectionUtils = new SubCollectionUtils(activeObjectsUtilities, workItemPersistence);
            this.workItemConstraintChecker = new WorkItemConstraintChecker(workItemPersistence);
        }

        @Override
        public Response getSpecificWorkItemsWithPost(EntityContext<IPlan> entityContext, boolean includeReplanning, RestIdList workItemIds) throws Exception {
            ArrayList workItems = Lists.newArrayList(this.workItemPersistence.listPlainWorkItemsForPlanForIds(entityContext.getEntityId(), workItemIds.getIds(), includeReplanning));
            List<RestWorkItem> list = ToRest.transferList(RestWorkItem.class, IWorkItem.class, workItems, includeReplanning);
            return entityContext.okForList(Iterables.toArray(list, RestWorkItem.class));
        }

        @Override
        public Response getFiltered(EntityContext<IPlan> entityContext, boolean includeReplanning, boolean useNativeOrder, RestWorkItemFilter filter) throws Exception {
            this.cleanupFilter(filter);
            String planId = entityContext.getEntityId();
            WorkItemSolutionFilterResult solutionFilterResult = WorkItemSolutionFilter.applySolutionFilter(filter, this.scheduling.getSolutionForPlan(planId));
            ProgressConfigurationPlanConfigWrapper progressConfiguration = new ProgressConfigurationPlanConfigWrapper(this.planPersistence.getPlanConfiguration(planId));
            MonitoredCallResult<? extends List<? extends IWorkItem>> call = this.workItemPersistence.listFullWorkItemsForPlanAndFilter(planId, includeReplanning, progressConfiguration, filter, solutionFilterResult);
            ArrayList workItems = Lists.newArrayList((Iterable)call.getResult());
            if (!useNativeOrder) {
                boolean includeDone = (Boolean)Optional.fromNullable((Object)filter.getShowCompleted()).or((Object)false);
                Map<String, Long> epicsSortOrder = this.workItemPersistence.getEpicsSortOrder(planId, !includeDone);
                Impl.setEpicSortOrderRecursive(workItems, epicsSortOrder);
            }
            Long totalWorkItemCount = this.workItemPersistence.countAllForPlan(planId);
            RestWorkItemFilterResult retVal = RestWorkItemFilterResult.create(workItems, includeReplanning, filter, totalWorkItemCount, progressConfiguration, call);
            return entityContext.ok(retVal);
        }

        private void cleanupFilter(RestWorkItemFilter filter) throws SQLException {
            filter.setReleaseIds(this.releasePersistence.existingSubset(filter.getReleaseIds()));
            filter.setTeamIds(this.teamPersistence.existingSubset(filter.getTeamIds()));
            filter.setStageIds(this.stagePersistence.existingSubset(filter.getStageIds()));
        }

        @Override
        public Response getAll(EntityContext<IPlan> entityContext, boolean includeReplanning, boolean useNativeOrder) throws Exception {
            String planId = entityContext.getEntityId();
            IPlanConfiguration planConfiguration = this.planPersistence.getPlanConfiguration(planId);
            RestProgressConfiguration progressConfiguration = RestProgressConfiguration.from(planConfiguration);
            MonitoredCallResult<? extends List<? extends IWorkItem>> call = this.workItemPersistence.listFullWorkItemsForPlan(planId, includeReplanning, progressConfiguration);
            ArrayList workItems = Lists.newArrayList((Iterable)call.getResult());
            if (!useNativeOrder) {
                Map<String, Long> epicsSortOrder = this.workItemPersistence.getEpicsSortOrder(planId, false);
                Impl.setEpicSortOrderRecursive(workItems, epicsSortOrder);
            }
            List<RestWorkItem> list = ToRest.transferList(RestWorkItem.class, IWorkItem.class, workItems, includeReplanning);
            return entityContext.okForList(Iterables.toArray(list, RestWorkItem.class));
        }

        @Override
        public Response addToPlan(EntityContext<IPlan> entityContext, final RestWorkItem newWorkItem) throws Exception {
            final String newItemParentId = newWorkItem.getParentId();
            final IWorkItem newItemParentOnRequestStart = newItemParentId != null ? (IWorkItem)this.workItemPersistence.get(newItemParentId) : null;
            final int newItemParentChildCountOnStart = newItemParentOnRequestStart != null ? newItemParentOnRequestStart.getChildren().size() : 0;
            String sortOrderId = WorkItems.OrderRangeIdentifiers.forType(newWorkItem.getType());
            return this.subCollectionUtils.handleAddEntityToCollection(entityContext, AOWorkItem.class, sortOrderId, newWorkItem, new SubCollectionUtilsCallback.Adapter<IPlan, IWorkItem, RestWorkItem>(){

                @Override
                public Response preOperationChecks() throws Exception {
                    if (newWorkItem.getType() == null) {
                        return ResponseBuilder.badRequest(RestMessaging.error("no type specified"));
                    }
                    try {
                        workItemConstraintChecker.checkAddAllowed(newWorkItem);
                    }
                    catch (WorkItemConstraintException ex) {
                        return ResponseBuilder.badRequest(ex.getRestMessage());
                    }
                    return null;
                }

                @Override
                public void setParent(IPlan parent, IWorkItem entity) {
                    if (newItemParentOnRequestStart != null) {
                        entity.setParent(newItemParentOnRequestStart);
                    }
                    entity.setPlan(parent);
                }

                @Override
                public IWorkItem persist(IWorkItem entity) throws PersistenceException {
                    return workItemPersistence.persist(entity);
                }

                @Override
                public void afterPostPersisting(RestWorkItem rest, IWorkItem entity) throws Exception {
                    workItemPersister.onAfterPostPersisting(rest, entity);
                    if (newItemParentOnRequestStart != null && newItemParentChildCountOnStart == 0) {
                        workItemPersistence.reactToCreationOfFirstChild(newItemParentId);
                        portfolioToJiraSyncExtension.syncWorkItemToIssues(IssueSyncData.createEstimateSyncFor(newItemParentId));
                    }
                }

                @Override
                public IWorkItem get(String id) throws Exception {
                    return (IWorkItem)workItemPersistence.get(id);
                }
            });
        }

        @Override
        public Response rank(EntityContext<IPlan> entityContext, RestRank rank) throws Exception {
            String sortOrderId;
            try {
                String firstId = rank.getElementIds().get(0).getId();
                sortOrderId = WorkItems.OrderRangeIdentifiers.forType(this.workItemPersistence.getWorkItemType(firstId));
            }
            catch (Exception ex) {
                return ResponseBuilder.badRequest(RestMessaging.entityNotFound());
            }
            return this.subCollectionUtils.rankEntity(entityContext, AOWorkItem.class, this.workItemPersistence, sortOrderId, rank);
        }

        private static void setEpicSortOrderRecursive(List<? extends IWorkItem> workItems, Map<String, Long> epicsSortOrder) {
            if (workItems == null) {
                return;
            }
            for (IWorkItem iWorkItem : workItems) {
                if (epicsSortOrder.containsKey(iWorkItem.getId())) {
                    iWorkItem.setSortOrder(epicsSortOrder.get(iWorkItem.getId()));
                }
                Impl.setEpicSortOrderRecursive(iWorkItem.getChildren(), epicsSortOrder);
            }
        }
    }
}

