/*
 * Decompiled with CFR 0.152.
 */
package com.radiantminds.roadmap.common.rest.services.workitems.constraints;

import com.radiantminds.roadmap.common.data.entities.workitems.IWorkItem;
import com.radiantminds.roadmap.common.data.entities.workitems.WorkItems;
import com.radiantminds.roadmap.common.data.persistence.common.entitypersistence.PortfolioWorkItemPersistence;
import com.radiantminds.roadmap.common.rest.entities.common.messaging.RestMessage;
import com.radiantminds.roadmap.common.rest.entities.common.messaging.RestMessaging;
import com.radiantminds.roadmap.common.rest.entities.workitems.RestWorkItem;
import com.radiantminds.roadmap.common.rest.services.workitems.constraints.IWorkItemConstraint;
import com.radiantminds.roadmap.common.rest.services.workitems.constraints.WorkItemConstraintException;
import com.radiantminds.roadmap.common.rest.services.workitems.constraints.WorkItemConstraints;
import java.sql.SQLException;

public class WorkItemConstraintChecker {
    public static final String ERROR_NO_TYPE_SUPPLIED = "no-type-supplied";
    public static final String ERROR_NO_STREAM_SUPPLIED = "no-stream-supplied";
    public static final String ERROR_STREAM_NOT_ALLOWED = "item-not-stream-assignable";
    public static final String ERROR_INVALID_PARENT = "invalid-parent";
    public static final RestMessage ERROR_ADD_WITH_ID = RestMessaging.addWithId();
    private final PortfolioWorkItemPersistence workItemPersistence;

    public WorkItemConstraintChecker(PortfolioWorkItemPersistence workItemPersistence) {
        this.workItemPersistence = workItemPersistence;
    }

    public static boolean isAssignable(IWorkItem item) throws SQLException {
        if (!WorkItemConstraintChecker.isTypeAssignable(item.getType())) {
            return false;
        }
        return item.getChildren() == null || item.getChildren().size() <= 0;
    }

    public String isAssignable(String id) throws SQLException {
        Integer type = this.workItemPersistence.getWorkItemType(id);
        if (!WorkItemConstraintChecker.isTypeAssignable(type)) {
            return "non-assignable-item";
        }
        if (this.workItemPersistence.countChildren(id) > 0) {
            return "workitem-has-children";
        }
        return null;
    }

    public static boolean requiresStream(RestWorkItem item) {
        return !item.getType().equals(WorkItems.Types.INITIATIVE);
    }

    public static boolean isTypeAssignable(Integer type) throws SQLException {
        return WorkItemConstraints.CONSTRAINT_MAP.get(type).isSchedulable();
    }

    public boolean isDependable(String workItemId) throws SQLException {
        Integer type = this.workItemPersistence.getWorkItemType(workItemId);
        return type != null && WorkItemConstraints.CONSTRAINT_MAP.get(type).isDependable();
    }

    public void checkAddAllowed(RestWorkItem item) throws WorkItemConstraintException, SQLException {
        if (item.getId() != null) {
            throw new WorkItemConstraintException(ERROR_ADD_WITH_ID);
        }
        Integer type = item.getType();
        if (type == null) {
            throw new WorkItemConstraintException(ERROR_NO_TYPE_SUPPLIED);
        }
        if (WorkItemConstraintChecker.requiresStream(item)) {
            if (item.getStreamId() == null) {
                throw new WorkItemConstraintException(ERROR_NO_STREAM_SUPPLIED);
            }
        } else if (item.getStreamId() != null) {
            throw new WorkItemConstraintException(ERROR_STREAM_NOT_ALLOWED);
        }
        IWorkItemConstraint constraint = WorkItemConstraints.CONSTRAINT_MAP.get(type);
        String parentId = item.getParentId();
        if (parentId == null && !constraint.getAllowedParentTypes().contains(null)) {
            throw new WorkItemConstraintException(ERROR_INVALID_PARENT);
        }
        if (parentId != null) {
            Integer parentType = this.workItemPersistence.getWorkItemType(parentId);
            if (parentType == null) {
                throw new WorkItemConstraintException(ERROR_INVALID_PARENT);
            }
            if (!constraint.getAllowedParentTypes().contains(parentType)) {
                throw new WorkItemConstraintException(ERROR_INVALID_PARENT);
            }
        }
    }
}

