/*
 * Decompiled with CFR 0.152.
 */
package com.radiantminds.roadmap.common.rest.services.workitems.dependencies;

import com.radiantminds.roadmap.common.data.persistence.common.entitypersistence.PortfolioWorkItemPersistence;
import com.radiantminds.roadmap.common.handlers.EntityContext;
import com.radiantminds.roadmap.common.handlers.SecuredInvocationHandlerFactory;
import com.radiantminds.roadmap.common.rest.common.ResponseBuilder;
import com.radiantminds.roadmap.common.rest.entities.workitems.RestDependencies;
import com.radiantminds.roadmap.common.rest.entities.workitems.RestDependency;
import com.radiantminds.roadmap.common.rest.services.workitems.dependencies.WorkItemDependencyServiceHandler;
import java.util.List;
import javax.ws.rs.Consumes;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Consumes(value={"application/json"})
@Produces(value={"application/json", "application/xml"})
@Path(value="/workitems/dependencies")
@Component
public class WorkItemDependencySetterService {
    private final WorkItemDependencyServiceHandler handler;

    @Autowired
    public WorkItemDependencySetterService(SecuredInvocationHandlerFactory handlerFactory, PortfolioWorkItemPersistence workItemPersistence) {
        this.handler = handlerFactory.createProxy(WorkItemDependencyServiceHandler.class, new WorkItemDependencyServiceHandler.Impl(workItemPersistence), workItemPersistence);
    }

    @POST
    public Response setDependency(@QueryParam(value="planVersion") Long expectedPlanVersion, @QueryParam(value="clientId") String clientId, RestDependencies restDependencies) throws Exception {
        if (restDependencies == null) {
            return ResponseBuilder.notFound();
        }
        List<RestDependency> dependencies = restDependencies.getDependencies();
        if (dependencies == null || dependencies.size() == 0) {
            return ResponseBuilder.notFound();
        }
        String planRelevantId = dependencies.get(0).getId();
        return this.handler.setDependency(EntityContext.from(planRelevantId, expectedPlanVersion, clientId), dependencies);
    }
}

