/*
 * Decompiled with CFR 0.152.
 */
package com.radiantminds.roadmap.common.rest.services.workitems.streamrelease;

import com.radiantminds.roadmap.common.data.persistence.common.entitypersistence.PortfolioStreamPersistence;
import com.radiantminds.roadmap.common.data.persistence.common.entitypersistence.PortfolioWorkItemPersistence;
import com.radiantminds.roadmap.common.handlers.BulkEntityContext;
import com.radiantminds.roadmap.common.handlers.SecuredInvocationHandlerFactory;
import com.radiantminds.roadmap.common.rest.entities.assignment.RestBulkReleaseStreamAssignment;
import com.radiantminds.roadmap.common.rest.services.common.OperationExecutor;
import com.radiantminds.roadmap.common.rest.services.workitems.streamrelease.WorkItemStreamReleaseServiceHandler;
import javax.ws.rs.Consumes;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Consumes(value={"application/json"})
@Produces(value={"application/json", "application/xml"})
@Path(value="/workitems/bulk/releasestream")
@Component
public class WorkItemBulkStreamReleaseService {
    private final WorkItemStreamReleaseServiceHandler handler;

    @Autowired
    public WorkItemBulkStreamReleaseService(OperationExecutor operationExecutor, SecuredInvocationHandlerFactory handlerFactory, PortfolioWorkItemPersistence workItemPersistence, PortfolioStreamPersistence streamPersistence) {
        this.handler = handlerFactory.createProxy(WorkItemStreamReleaseServiceHandler.class, new WorkItemStreamReleaseServiceHandler.Impl(operationExecutor, workItemPersistence, streamPersistence), workItemPersistence);
    }

    @PUT
    public Response setReleaseStreamAssignmentInBulk(@QueryParam(value="planVersion") String expectedPlanVersion, RestBulkReleaseStreamAssignment assignment) throws Exception {
        return this.handler.setAssignmentInBulk(BulkEntityContext.from(assignment.getIds()), assignment.getAssignment());
    }

    @PUT
    @Path(value="/replanning")
    public Response setReplanningReleaseStreamAssignmentInBulk(@QueryParam(value="planVersion") String expectedPlanVersion, RestBulkReleaseStreamAssignment assignment) throws Exception {
        return this.handler.setReplanningAssignmentInBulk(BulkEntityContext.from(assignment.getIds()), assignment.getAssignment());
    }
}

