/*
 * Decompiled with CFR 0.152.
 */
package com.radiantminds.roadmap.common.scheduling.entities;

import com.radiantminds.roadmap.common.data.entities.plans.FullContentSchedulingPlan;
import com.radiantminds.roadmap.common.data.persistence.common.entitypersistence.PortfolioNonWorkingDaysPersistence;
import com.radiantminds.roadmap.common.data.persistence.common.entitypersistence.PortfolioStagePersistence;
import com.radiantminds.roadmap.common.data.persistence.common.entitypersistence.PortfolioStreamPersistence;
import com.radiantminds.roadmap.common.data.persistence.common.entitypersistence.PortfolioTeamPersistence;
import com.radiantminds.roadmap.common.data.persistence.common.entitypersistence.PortfolioThemePersistence;
import com.radiantminds.roadmap.common.data.persistence.common.entitypersistence.PortfolioWorkItemPersistence;
import com.radiantminds.roadmap.common.data.persistence.services.PortfolioPlanPersistence;
import com.radiantminds.roadmap.common.scheduling.entities.LocalSchedulingPlan;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class SchedulingPlanFactory {
    private final PortfolioPlanPersistence planPersistence;
    private final PortfolioWorkItemPersistence workItemPersistence;
    private final PortfolioThemePersistence themePersistence;
    private final PortfolioStagePersistence stagePersistence;
    private final PortfolioTeamPersistence teamPersistence;
    private final PortfolioStreamPersistence streamPersistence;
    private final PortfolioNonWorkingDaysPersistence nonWorkingDaysPersistence;

    @Autowired
    public SchedulingPlanFactory(PortfolioPlanPersistence planPersistence, PortfolioWorkItemPersistence workItemPersistence, PortfolioThemePersistence themePersistence, PortfolioStagePersistence stagePersistence, PortfolioTeamPersistence teamPersistence, PortfolioStreamPersistence streamPersistence, PortfolioNonWorkingDaysPersistence nonWorkingDaysPersistence) {
        this.planPersistence = planPersistence;
        this.workItemPersistence = workItemPersistence;
        this.themePersistence = themePersistence;
        this.stagePersistence = stagePersistence;
        this.teamPersistence = teamPersistence;
        this.streamPersistence = streamPersistence;
        this.nonWorkingDaysPersistence = nonWorkingDaysPersistence;
    }

    public FullContentSchedulingPlan create(String planId) throws Exception {
        return new LocalSchedulingPlan(planId, this.planPersistence, this.workItemPersistence, this.themePersistence, this.stagePersistence, this.teamPersistence, this.streamPersistence, this.nonWorkingDaysPersistence);
    }
}

