/*
 * Decompiled with CFR 0.152.
 */
package com.radiantminds.roadmap.common.scheduling.entities.transferables;

import com.google.common.base.Optional;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.radiantminds.roadmap.common.data.entities.workitems.SchedulingEstimate;
import com.radiantminds.roadmap.common.data.entities.workitems.SchedulingWorkItem;
import com.radiantminds.roadmap.common.data.entities.workitems.WorkItemType;
import com.radiantminds.roadmap.common.scheduling.entities.transferables.TransferableEstimate;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;

public class TransferableWorkItem
implements SchedulingWorkItem {
    private String parentId;
    private String releaseId;
    private String teamId;
    private String sprintId;
    private String streamId;
    private Set<String> resourceIds;
    private Long earliestStart;
    private Long targetStart;
    private Long targetEnd;
    private Integer status;
    private List<String> prerequisites;
    private Integer workItemType;
    private TransferableEstimate total;
    private List<TransferableEstimate> skills;
    private List<TransferableEstimate> stages;
    private String id;
    private Long sortOrder;
    private Set<String> streamTeamRestrictions;

    TransferableWorkItem(SchedulingWorkItem workItem) {
        this.id = workItem.getId();
        this.sortOrder = workItem.getSortOrder();
        this.streamTeamRestrictions = workItem.getStreamTeamRestrictions();
        this.parentId = workItem.getParentId();
        this.releaseId = workItem.getReleaseId();
        this.teamId = (String)workItem.getTeamId().orNull();
        this.sprintId = (String)workItem.getSprintId().orNull();
        this.streamId = workItem.getStreamId();
        this.resourceIds = workItem.getResources();
        this.earliestStart = workItem.getEarliestStart();
        this.targetStart = (Long)workItem.getTargetStart().orNull();
        this.targetEnd = (Long)workItem.getTargetEnd().orNull();
        this.prerequisites = workItem.getPrerequisites();
        this.workItemType = workItem.getType();
        this.status = workItem.getStatus();
        if (workItem.getTotalEstimate().isPresent()) {
            this.total = new TransferableEstimate((SchedulingEstimate)workItem.getTotalEstimate().get());
        }
        this.skills = Lists.newArrayList();
        for (SchedulingEstimate estimate : workItem.getSkillEstimates()) {
            this.skills.add(new TransferableEstimate(estimate));
        }
        this.stages = Lists.newArrayList();
        for (SchedulingEstimate estimate : workItem.getStageEstimates()) {
            this.stages.add(new TransferableEstimate(estimate));
        }
    }

    @Override
    public String getParentId() {
        return this.parentId;
    }

    @Override
    public String getReleaseId() {
        return this.releaseId;
    }

    @Override
    public String getStreamId() {
        return this.streamId;
    }

    @Override
    public Optional<String> getTeamId() {
        return Optional.fromNullable((Object)this.teamId);
    }

    @Override
    public Optional<String> getSprintId() {
        return Optional.fromNullable((Object)this.sprintId);
    }

    @Override
    public Integer getType() {
        return this.workItemType;
    }

    @Override
    public Integer getStatus() {
        return this.status;
    }

    @Override
    public Long getEarliestStart() {
        return this.earliestStart;
    }

    @Override
    public Optional<Long> getTargetStart() {
        return Optional.fromNullable((Object)this.targetStart);
    }

    @Override
    public Optional<Long> getTargetEnd() {
        return Optional.fromNullable((Object)this.targetEnd);
    }

    @Override
    public List<String> getPrerequisites() {
        return this.prerequisites;
    }

    @Override
    public Optional<SchedulingEstimate> getTotalEstimate() {
        return Optional.fromNullable((Object)this.total);
    }

    @Override
    public Collection<SchedulingEstimate> getSkillEstimates() {
        return Collections.unmodifiableCollection(this.skills);
    }

    @Override
    public Collection<SchedulingEstimate> getStageEstimates() {
        return Collections.unmodifiableCollection(this.stages);
    }

    @Override
    public Long getSortOrder() {
        return this.sortOrder;
    }

    @Override
    public Set<String> getResources() {
        if (this.resourceIds == null) {
            this.resourceIds = Sets.newHashSet();
        }
        return this.resourceIds;
    }

    @Override
    public Optional<? extends SchedulingEstimate> getEstimateForSkill(String id) {
        for (TransferableEstimate skill : this.skills) {
            if (!String.valueOf(skill.getTargetId()).equals(id)) continue;
            return Optional.of((Object)skill);
        }
        return Optional.absent();
    }

    @Override
    public Optional<? extends SchedulingEstimate> getEstimateForStage(String id) {
        for (TransferableEstimate stage : this.stages) {
            if (!String.valueOf(stage.getTargetId()).equals(id)) continue;
            return Optional.of((Object)stage);
        }
        return Optional.absent();
    }

    @Override
    public Set<String> getStreamTeamRestrictions() {
        return this.streamTeamRestrictions;
    }

    @Override
    public Set<String> getChildIds() {
        if (this.prerequisites == null) {
            return Sets.newHashSet();
        }
        return Sets.newHashSet(this.prerequisites);
    }

    @Override
    public Set<String> getResourceIds() {
        return this.resourceIds;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public WorkItemType getWorkItemType() {
        return WorkItemType.fromCode(this.getType());
    }
}

