/*
 * Decompiled with CFR 0.152.
 */
package com.radiantminds.roadmap.common.scheduling.retrafo.solution;

import com.atlassian.pocketknife.api.logging.Log;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.problem.IRoadmapProblem;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.solution.IRoadmapSchedule;
import com.radiantminds.roadmap.common.scheduling.common.ITimeTransformer;
import com.radiantminds.roadmap.common.scheduling.retrafo.solution.AssignmentsTransformer;
import com.radiantminds.roadmap.common.scheduling.retrafo.solution.IPlanSolution;
import com.radiantminds.roadmap.common.scheduling.retrafo.solution.IRoadmapToPlanSolutionTransformer;
import com.radiantminds.roadmap.common.scheduling.retrafo.solution.PlanSolution;
import com.radiantminds.roadmap.common.scheduling.retrafo.solution.ReleaseTransformer;
import com.radiantminds.roadmap.common.scheduling.retrafo.solution.RoadmapStatisticsTransformer;
import com.radiantminds.roadmap.common.scheduling.retrafo.solution.ScheduleAnnotations;
import com.radiantminds.roadmap.common.scheduling.retrafo.solution.cap.RoadmapCapacityStatisticTransformer;
import com.radiantminds.roadmap.common.scheduling.retrafo.stats.IRoadmapStatistics;
import com.radiantminds.roadmap.common.scheduling.retrafo.stats.IRoadmapStatisticsProvider;
import com.radiantminds.roadmap.common.scheduling.retrafo.stats.ScheduleStatisticsProvider;
import com.radiantminds.roadmap.common.scheduling.retrafo.stats.cap.CapacityStatisticCalculator;
import com.radiantminds.roadmap.common.scheduling.retrafo.stats.cap.RoadmapCapacityStatistic;
import javax.annotation.concurrent.Immutable;

@Immutable
public class RoadmapToPlanSolutionTransformer
implements IRoadmapToPlanSolutionTransformer {
    private static final Log LOGGER = Log.with(RoadmapToPlanSolutionTransformer.class);
    private final ITimeTransformer timeTransformer;
    private final AssignmentsTransformer assignmentsTransformer;
    private final ReleaseTransformer releaseTransformer;
    private final IRoadmapStatisticsProvider statisticsProvider = new ScheduleStatisticsProvider();
    private final RoadmapStatisticsTransformer roadmapStatisticsTransformer;
    private final CapacityStatisticCalculator capacityStatisticCalculator;
    private final RoadmapCapacityStatisticTransformer capacityStatisticTransformer;

    public RoadmapToPlanSolutionTransformer(ITimeTransformer timeTransformer) {
        this.timeTransformer = timeTransformer;
        this.assignmentsTransformer = new AssignmentsTransformer(timeTransformer);
        this.roadmapStatisticsTransformer = new RoadmapStatisticsTransformer(timeTransformer);
        this.releaseTransformer = new ReleaseTransformer(timeTransformer);
        this.capacityStatisticTransformer = new RoadmapCapacityStatisticTransformer(timeTransformer);
        this.capacityStatisticCalculator = new CapacityStatisticCalculator(timeTransformer);
    }

    @Override
    public IPlanSolution transform(Long solutionVersion, IRoadmapSchedule schedule, IRoadmapProblem problem) {
        LOGGER.info("start solution transformation", new Object[0]);
        IRoadmapStatistics roadmapStatistics = this.statisticsProvider.calculateScheduleStatistics(schedule, problem);
        RoadmapCapacityStatistic capacityStatistics = this.capacityStatisticCalculator.calculateCapacityStatistic(problem, schedule, roadmapStatistics);
        PlanSolution planSolution = new PlanSolution(solutionVersion, this.assignmentsTransformer.transform(schedule.getWorkAssignments()), new ScheduleAnnotations(schedule.getViolations(), schedule.getWarnings()), this.roadmapStatisticsTransformer.transform(roadmapStatistics), this.releaseTransformer.transform(schedule.getEpisodeSchedulesPrioOrdered()), this.timeTransformer.getInstant(0), this.capacityStatisticTransformer.transform(capacityStatistics));
        LOGGER.info("finish solution transformation", new Object[0]);
        return planSolution;
    }
}

