/*
 * Decompiled with CFR 0.152.
 */
package com.radiantminds.roadmap.common.scheduling.retrafo.solution.cap;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.radiantminds.roadmap.common.scheduling.common.ITimeTransformer;
import com.radiantminds.roadmap.common.scheduling.retrafo.solution.cap.ConvertingResourceSprintStatistic;
import com.radiantminds.roadmap.common.scheduling.retrafo.solution.cap.ResourceSprintStatistic;
import com.radiantminds.roadmap.common.scheduling.retrafo.solution.cap.ScheduleCapacityStatistic;
import com.radiantminds.roadmap.common.scheduling.retrafo.solution.cap.TeamCapacityStatistic;
import com.radiantminds.roadmap.common.scheduling.retrafo.solution.cap.TeamCapacityStatisticImpl;
import com.radiantminds.roadmap.common.scheduling.retrafo.solution.cap.TeamSprintCapacityStatistic;
import com.radiantminds.roadmap.common.scheduling.retrafo.solution.cap.TeamSprintCapacityStatisticImpl;
import com.radiantminds.roadmap.common.scheduling.retrafo.stats.cap.GroupCapacityStatistic;
import com.radiantminds.roadmap.common.scheduling.retrafo.stats.cap.GroupIntervalCapacityStatistic;
import com.radiantminds.roadmap.common.scheduling.retrafo.stats.cap.ResourceIntervalCapacityStatistic;
import com.radiantminds.roadmap.common.scheduling.retrafo.stats.cap.RoadmapCapacityStatistic;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class RoadmapCapacityStatisticTransformer {
    private final ITimeTransformer timeTransformer;

    public RoadmapCapacityStatisticTransformer(ITimeTransformer timeTransformer) {
        this.timeTransformer = timeTransformer;
    }

    public ScheduleCapacityStatistic transform(RoadmapCapacityStatistic roadmapStatistic) {
        final HashSet teamStatistics = Sets.newHashSet();
        for (GroupCapacityStatistic groupStatistic : roadmapStatistic.getTeamCapacityStatistics()) {
            teamStatistics.add(this.transformGroupStatistic(groupStatistic));
        }
        return new ScheduleCapacityStatistic(){

            @Override
            public Set<TeamCapacityStatistic> getTeamCapacityStatistics() {
                return teamStatistics;
            }
        };
    }

    private TeamCapacityStatistic transformGroupStatistic(GroupCapacityStatistic groupStatistic) {
        return new TeamCapacityStatisticImpl(groupStatistic, this.transformGroupSprintStats(groupStatistic.getIntervalCapacityStatistics()));
    }

    private List<TeamSprintCapacityStatistic> transformGroupSprintStats(List<GroupIntervalCapacityStatistic> intervalCapacityStatistics) {
        ArrayList teamSprintStatistics = Lists.newArrayList();
        for (GroupIntervalCapacityStatistic intervalStatistic : intervalCapacityStatistics) {
            teamSprintStatistics.add(this.transformIntervalStatistic(intervalStatistic));
        }
        return teamSprintStatistics;
    }

    private TeamSprintCapacityStatistic transformIntervalStatistic(GroupIntervalCapacityStatistic intervalStatistic) {
        return new TeamSprintCapacityStatisticImpl(intervalStatistic, this.createResourceStats(intervalStatistic.getResourceIntervalCapacityStatistics()), this.timeTransformer);
    }

    private Set<ResourceSprintStatistic> createResourceStats(Set<ResourceIntervalCapacityStatistic> roadmapStats) {
        HashSet scheduleStats = Sets.newHashSet();
        for (ResourceIntervalCapacityStatistic statistic : roadmapStats) {
            scheduleStats.add(this.transformResourceStatistic(statistic));
        }
        return scheduleStats;
    }

    private ResourceSprintStatistic transformResourceStatistic(ResourceIntervalCapacityStatistic statistic) {
        return new ConvertingResourceSprintStatistic(statistic, this.timeTransformer);
    }
}

