/*
 * Decompiled with CFR 0.152.
 */
package com.radiantminds.roadmap.common.scheduling.retrafo.stats.cap;

import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.group.IResourceGroup;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.problem.IRoadmapProblem;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.solution.IRoadmapSchedule;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.time.IEpisodeStream;
import com.google.common.collect.Sets;
import com.radiantminds.roadmap.common.scheduling.common.ITimeTransformer;
import com.radiantminds.roadmap.common.scheduling.retrafo.stats.IRoadmapStatistics;
import com.radiantminds.roadmap.common.scheduling.retrafo.stats.cap.GroupCapacityStatistic;
import com.radiantminds.roadmap.common.scheduling.retrafo.stats.cap.GroupCapacityStatisticImpl;
import com.radiantminds.roadmap.common.scheduling.retrafo.stats.cap.GroupIntervalCapacityStatisticCalculator;
import java.util.HashSet;
import java.util.Set;

public class GroupCapacityCalculator {
    private final GroupIntervalCapacityStatisticCalculator groupIntervalCapacityStatisticCalculator;

    public GroupCapacityCalculator(ITimeTransformer timeTransformer) {
        this(new GroupIntervalCapacityStatisticCalculator(timeTransformer));
    }

    GroupCapacityCalculator(GroupIntervalCapacityStatisticCalculator groupIntervalCapacityStatisticCalculator) {
        this.groupIntervalCapacityStatisticCalculator = groupIntervalCapacityStatisticCalculator;
    }

    public GroupCapacityStatistic calculateStatistic(IResourceGroup group, IRoadmapProblem problem, IRoadmapSchedule solution, IRoadmapStatistics roadmapStatistics) {
        return new GroupCapacityStatisticImpl(group, this.getAssociatedStreams(problem, group), this.groupIntervalCapacityStatisticCalculator.calculateIntervalStatistics(group, solution, roadmapStatistics));
    }

    private Set<IEpisodeStream> getAssociatedStreams(IRoadmapProblem problem, IResourceGroup group) {
        HashSet assignableStreams = Sets.newHashSet();
        for (IEpisodeStream stream : problem.getTimePlan().getEpisodeStreams()) {
            if (!stream.getAssignableGroupIds().contains(group.getId())) continue;
            assignableStreams.add(stream);
        }
        return assignableStreams;
    }
}

