/*
 * Decompiled with CFR 0.152.
 */
package com.radiantminds.roadmap.common.scheduling.trafo.backlog;

import com.atlassian.pocketknife.api.logging.Log;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.annotation.IScheduleViolation;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.annotation.IStageRestrictionViolationDetector;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.annotation.StageRestrictionViolationDetector;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.assignment.AssignmentRestriction;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.work.IAggregatedWorkPackage;
import com.google.common.base.Optional;
import com.radiantminds.roadmap.common.data.entities.workitems.SchedulingWorkItem;
import com.radiantminds.roadmap.common.data.entities.workitems.WorkItems;
import com.radiantminds.roadmap.common.scheduling.trafo.backlog.EpicSkillsViolationDetector;
import com.radiantminds.roadmap.common.scheduling.trafo.backlog.IEpicSkillsViolationDetector;
import com.radiantminds.roadmap.common.scheduling.trafo.backlog.IStorySkillsViolationDetector;
import com.radiantminds.roadmap.common.scheduling.trafo.backlog.NoAssignmentPoolViolationDetector;
import com.radiantminds.roadmap.common.scheduling.trafo.backlog.StorySkillsViolationDetector;
import com.radiantminds.roadmap.common.scheduling.trafo.teams.TeamsTransformationResult;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;

@Immutable
class ViolationDetector {
    private static final Log LOGGER = Log.with(ViolationDetector.class);
    private final IStorySkillsViolationDetector storySkillViolationDetector;
    private final IStageRestrictionViolationDetector stageRestrictionViolationDetector;
    private final IEpicSkillsViolationDetector epicSkillsViolationDetector;
    private final NoAssignmentPoolViolationDetector noAssignmentPoolViolationDetector = new NoAssignmentPoolViolationDetector();

    ViolationDetector(IStorySkillsViolationDetector storySkillViolationDetector, IStageRestrictionViolationDetector stageRestrictionViolationDetector, IEpicSkillsViolationDetector epicSkillsViolationDetector) {
        this.storySkillViolationDetector = storySkillViolationDetector;
        this.stageRestrictionViolationDetector = stageRestrictionViolationDetector;
        this.epicSkillsViolationDetector = epicSkillsViolationDetector;
    }

    public ViolationDetector(long maxResourcesPerStage) {
        this(new StorySkillsViolationDetector(), new StageRestrictionViolationDetector(maxResourcesPerStage), new EpicSkillsViolationDetector());
    }

    Optional<IScheduleViolation> tryFindViolation(@Nullable IAggregatedWorkPackage workDemand, SchedulingWorkItem workItem, @Nullable AssignmentRestriction assignment, TeamsTransformationResult teamTransformation) {
        LOGGER.debug("try find violation for work item: %s", workItem);
        if (workDemand == null) {
            return Optional.absent();
        }
        if (assignment == null) {
            return Optional.of((Object)this.noAssignmentPoolViolationDetector.handleInvalidAssignment(workDemand, workItem));
        }
        if (WorkItems.Types.EPIC.equals(workItem.getType())) {
            return this.epicSkillsViolationDetector.tryFindMissingSkillViolation(workItem.getId(), workDemand.getResourceTypes(), assignment);
        }
        Optional<IScheduleViolation> missingTypeViolation = this.storySkillViolationDetector.tryFindMissingTypeViolation(workItem, workDemand.getResourceTypes(), assignment, teamTransformation.getIgnoredTeams());
        if (missingTypeViolation.isPresent()) {
            return missingTypeViolation;
        }
        return this.stageRestrictionViolationDetector.tryFindRestrictionViolation(workItem.getId(), workDemand, assignment);
    }
}

