/*
 * Decompiled with CFR 0.152.
 */
package com.radiantminds.roadmap.common.scheduling.trafo.teams.common;

import com.atlassian.pocketknife.api.logging.Log;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.group.TimeStepPresenceFunction;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.resources.BoundAvailability;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.resources.IStepWiseResourceAvailability;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.resources.StepWiseResourceAvailability;
import com.atlassian.rm.jpo.scheduling.util.RmUtils;
import com.atlassian.rm.jpo.scheduling.util.function.IntegerInterval;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.radiantminds.roadmap.common.data.entities.people.SchedulingAvailability;
import com.radiantminds.roadmap.common.data.entities.people.SchedulingResource;
import com.radiantminds.roadmap.common.scheduling.common.ITimeTransformer;
import com.radiantminds.roadmap.common.scheduling.trafo.teams.common.IntervalUtils;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;

@Immutable
class ResourceAvailabilityCreator {
    private static final Log LOGGER = Log.with(ResourceAvailabilityCreator.class);
    private final ITimeTransformer timeTransformer;
    private final TimeStepPresenceFunction timeStepPresenceFunction;

    ResourceAvailabilityCreator(ITimeTransformer timeTransformer, TimeStepPresenceFunction timeStepPresenceFunction) {
        this.timeTransformer = timeTransformer;
        this.timeStepPresenceFunction = timeStepPresenceFunction;
    }

    Optional<IStepWiseResourceAvailability> createAvailability(SchedulingResource resource) {
        IStepWiseResourceAvailability availability;
        LOGGER.debug("create availability function", new Object[0]);
        if (this.timeStepPresenceFunction.isAllDisabled()) {
            return Optional.absent();
        }
        float staticDailyAvailability = this.getStaticDailyAvailability(resource);
        List<? extends SchedulingAvailability> filteredAvailabilities = this.getRelevantIntervals(resource);
        List<BoundAvailability> boundAvailabilities = this.transformToBoundAvailabilities(filteredAvailabilities, staticDailyAvailability);
        SchedulingAvailability firstRightOpenInterval = (SchedulingAvailability)IntervalUtils.getFirstRightOpenInterval(filteredAvailabilities).orNull();
        if (firstRightOpenInterval != null) {
            staticDailyAvailability = firstRightOpenInterval.getAvailability().floatValue() / (float)this.timeStepPresenceFunction.getWeeklyWorkDays();
        }
        if ((availability = (IStepWiseResourceAvailability)StepWiseResourceAvailability.createInstance(boundAvailabilities, staticDailyAvailability).orNull()) == null) {
            return Optional.absent();
        }
        LOGGER.debug("created availability function: %s", availability);
        return Optional.of((Object)availability);
    }

    private float getStaticDailyAvailability(SchedulingResource resource) {
        if (resource.getAvailability() == null) {
            return this.timeStepPresenceFunction.getDefaultDailyHours();
        }
        return Math.max(0.0f, resource.getAvailability().floatValue()) / (float)this.timeStepPresenceFunction.getWeeklyWorkDays();
    }

    private List<BoundAvailability> transformToBoundAvailabilities(List<? extends SchedulingAvailability> filteredAvailabilities, float staticDailyAvailability) {
        ArrayList boundAvailabilities = Lists.newArrayList();
        if (filteredAvailabilities.isEmpty()) {
            return boundAvailabilities;
        }
        int irregularUpperBound = this.getUnregularFunctionUpperBound(filteredAvailabilities);
        for (SchedulingAvailability schedulingAvailability : filteredAvailabilities) {
            Optional<BoundAvailability> boundAvailability = ResourceAvailabilityCreator.create(schedulingAvailability, this.timeTransformer, this.timeStepPresenceFunction, irregularUpperBound);
            if (!boundAvailability.isPresent()) continue;
            boundAvailabilities.add(boundAvailability.get());
        }
        SchedulingAvailability firstRightOpenInterval = (SchedulingAvailability)IntervalUtils.getFirstRightOpenInterval(filteredAvailabilities).orNull();
        if (firstRightOpenInterval != null && irregularUpperBound >= 0) {
            BoundAvailability boundAvailability = new BoundAvailability(0, irregularUpperBound, staticDailyAvailability);
            boundAvailabilities.add(boundAvailability);
        }
        return boundAvailabilities;
    }

    private int getUnregularFunctionUpperBound(List<? extends SchedulingAvailability> filteredAvailabilities) {
        Optional<Integer> latestClosedIntervalEnd = IntervalUtils.getMaxClosedIntervalEnd(filteredAvailabilities, this.timeTransformer);
        Integer highestPrioOpenIntervalStart = (Integer)IntervalUtils.getHighestPrioOpenIntervalStart(filteredAvailabilities, this.timeTransformer).orNull();
        if (highestPrioOpenIntervalStart != null) {
            return RmUtils.getOptionalMax(highestPrioOpenIntervalStart - 1, latestClosedIntervalEnd);
        }
        return (Integer)latestClosedIntervalEnd.get();
    }

    private List<? extends SchedulingAvailability> getRelevantIntervals(SchedulingResource resource) {
        List<? extends SchedulingAvailability> availabilityIntervals = resource.getAvailabilityIntervals();
        return IntervalUtils.filterValidTimelyIntervals(availabilityIntervals, this.timeTransformer.getInstant(0));
    }

    static Optional<BoundAvailability> create(SchedulingAvailability availability, ITimeTransformer timeTransformer, TimeStepPresenceFunction timeStepPresenceFunction, @Nullable Integer upperBound) {
        Preconditions.checkNotNull((Object)availability, (Object)"availability definition must not be null");
        Preconditions.checkArgument((upperBound != null || availability.getEndDate() != null ? 1 : 0) != 0);
        LOGGER.debug("create bound availability for: %s", availability);
        Double weeklyAvailability = availability.getAvailability();
        if (weeklyAvailability == null) {
            weeklyAvailability = 0.0;
        }
        if (weeklyAvailability < 0.0) {
            LOGGER.debug("no valid availability", new Object[0]);
            return Optional.absent();
        }
        int startTimeStep = IntervalUtils.getNullSafeStartTime(availability, timeTransformer);
        if (upperBound != null && upperBound < startTimeStep) {
            LOGGER.debug("cut by upper bound", new Object[0]);
            return Optional.absent();
        }
        IntegerInterval integerInterval = ResourceAvailabilityCreator.createIntegerInterval(availability, timeTransformer, upperBound);
        if (integerInterval.getLength() == 0) {
            LOGGER.debug("empty interval", new Object[0]);
            return Optional.absent();
        }
        float dailyAvailability = weeklyAvailability.floatValue() / (float)timeStepPresenceFunction.getWeeklyWorkDays();
        BoundAvailability instance = new BoundAvailability(integerInterval, dailyAvailability);
        LOGGER.debug("created instance: %s", instance);
        return Optional.of((Object)instance);
    }

    private static IntegerInterval createIntegerInterval(SchedulingAvailability availability, ITimeTransformer timeTransformer, @Nullable Integer upperBound) {
        int lower = IntervalUtils.getNullSafeStartTime(availability, timeTransformer);
        int upper = ResourceAvailabilityCreator.getUpperBound(availability, timeTransformer, upperBound);
        IntegerInterval integerInterval = new IntegerInterval(lower, upper);
        return integerInterval;
    }

    private static int getUpperBound(SchedulingAvailability availability, ITimeTransformer timeTransformer, @Nullable Integer upperBound) {
        Long endDate = availability.getEndDate();
        if (endDate == null) {
            return upperBound;
        }
        int endTimeStep = timeTransformer.getTimestep(endDate);
        return Math.min(upperBound, endTimeStep);
    }
}

