/*
 * Decompiled with CFR 0.152.
 */
package com.radiantminds.roadmap.jira.common.components.extension.issues.data;

import com.atlassian.rm.jpo.scheduling.util.RmUtils;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Maps;
import com.radiantminds.roadmap.common.data.entities.workitems.WorkItemExtensionLinkData;
import com.radiantminds.roadmap.common.extensions.workitems.EstimateRatioData;
import com.radiantminds.roadmap.common.extensions.workitems.ProgressConfiguration;
import com.radiantminds.roadmap.common.extensions.workitems.ProgressData;
import com.radiantminds.roadmap.common.extensions.workitems.StatusData;
import com.radiantminds.roadmap.common.extensions.workitems.WorkData;
import com.radiantminds.roadmap.common.stats.MonitoredCallResult;
import com.radiantminds.roadmap.common.stats.MonitoredCallResultWrapper;
import com.radiantminds.roadmap.common.stats.RuntimeMonitorData;
import com.radiantminds.roadmap.jira.common.components.agile.JiraAgileAccessor;
import com.radiantminds.roadmap.jira.common.components.extension.issues.data.JiraExtensionData;
import com.radiantminds.roadmap.jira.common.components.extension.issues.data.JiraLinkStatusDataWrapper;
import com.radiantminds.roadmap.jira.common.components.extension.issues.data.hierarchy.HierarchicalJiraIssueData;
import com.radiantminds.roadmap.jira.common.components.extension.issues.data.hierarchy.HierarchicalJiraIssueDataExtractor;
import com.radiantminds.roadmap.jira.common.components.extension.issues.data.hierarchy.JiraLinkEnrichmentData;
import com.radiantminds.roadmap.jira.common.components.extension.issues.data.hierarchy.LuceneJiraIssueAccessor;
import com.radiantminds.roadmap.jira.common.components.extension.issues.data.progress.FullProgressCalculator;
import com.radiantminds.roadmap.jira.common.components.extension.issues.data.progress.FullProgressCalculatorFactory;
import com.radiantminds.roadmap.jira.common.components.extension.issues.data.progress.ProgressDataExtractorFactory;
import com.radiantminds.roadmap.jira.common.components.extension.issues.data.progress.SelfProgressExtractor;
import com.radiantminds.roadmap.jira.common.components.extension.issues.data.time.JiraIssueTimeData;
import com.radiantminds.roadmap.jira.common.components.utils.customfields.CustomFields;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class IssueDataRequestHandler {
    private static final String METRIC_ID = "extensionDataDurationMs";
    private final HierarchicalJiraIssueDataExtractor hierarchicalJiraIssueDataExtractor;
    private final JiraAgileAccessor jiraAgileAccessor;
    private final CustomFields customFields;

    public IssueDataRequestHandler(JiraAgileAccessor jiraAgileAccessor, CustomFields customFields, LuceneJiraIssueAccessor luceneJiraIssueAccessor) {
        this.jiraAgileAccessor = jiraAgileAccessor;
        this.customFields = customFields;
        this.hierarchicalJiraIssueDataExtractor = new HierarchicalJiraIssueDataExtractor(luceneJiraIssueAccessor);
    }

    public MonitoredCallResult<WorkItemExtensionLinkData> getData(Set<String> issueKeys, ProgressConfiguration progressConfiguration) throws Exception {
        long startMs = System.currentTimeMillis();
        HierarchicalJiraIssueData issueHierarchy = this.hierarchicalJiraIssueDataExtractor.getData(issueKeys);
        SelfProgressExtractor selfProgressDataExtractor = ProgressDataExtractorFactory.createInstance(progressConfiguration, this.jiraAgileAccessor, this.customFields, issueHierarchy.getIssuesByKey());
        Map<String, JiraLinkEnrichmentData> issueInfosByKey = issueHierarchy.getIssueInfoByKey();
        Map<String, ProgressData> selfProgressMap = selfProgressDataExtractor.getProgressData(issueInfosByKey);
        FullProgressCalculator progress = FullProgressCalculatorFactory.create(issueHierarchy, progressConfiguration, this.jiraAgileAccessor, this.customFields);
        Map<String, ProgressData> fullProgresses = progress.calculate();
        return MonitoredCallResultWrapper.wrap(new JiraExtensionData(this.createStatusData(issueInfosByKey), selfProgressMap, fullProgresses, this.createTimeData(issueHierarchy), this.createEstimateRatioData(issueHierarchy.getEstimateRatioRelevantRelations(), selfProgressMap), issueHierarchy.getJpoJiraKeyMap()), RuntimeMonitorData.create(METRIC_ID, startMs).getMonitoredMetrics());
    }

    private Map<String, EstimateRatioData> createEstimateRatioData(Map<String, Set<String>> estimateRatioRelevantRelations, Map<String, ProgressData> selfProgressMap) {
        HashMap estimateRatioData = Maps.newHashMap();
        for (Map.Entry<String, Set<String>> entry : estimateRatioRelevantRelations.entrySet()) {
            estimateRatioData.put(entry.getKey(), EstimateRatioData.create(this.getRelatedProgresses(selfProgressMap, entry.getValue())));
        }
        return estimateRatioData;
    }

    private Collection<ProgressData> getRelatedProgresses(Map<String, ProgressData> selfProgressMap, Set<String> relatedIds) {
        return Maps.filterKeys(selfProgressMap, (Predicate)Predicates.in(relatedIds)).values();
    }

    private Map<String, WorkData> createTimeData(HierarchicalJiraIssueData issueHierarchy) {
        Map<String, JiraLinkEnrichmentData> issueInfoByKey = issueHierarchy.getIssueInfoByKey();
        HashMap timeDataMap = Maps.newHashMap();
        for (String link : issueInfoByKey.keySet()) {
            JiraLinkEnrichmentData issueInfo = issueInfoByKey.get(link);
            if (issueInfo == null) continue;
            Collection<JiraLinkEnrichmentData> transitiveSuccessorInfos = RmUtils.filterMapByNullableKeys(issueInfoByKey, issueHierarchy.getTransitiveSuccessors(link)).values();
            WorkData linkStatus = JiraIssueTimeData.create(issueInfo, transitiveSuccessorInfos);
            timeDataMap.put(link, linkStatus);
        }
        return timeDataMap;
    }

    private Map<String, StatusData> createStatusData(Map<String, JiraLinkEnrichmentData> issuesByKey) {
        HashMap statusMap = Maps.newHashMap();
        for (String link : issuesByKey.keySet()) {
            JiraLinkEnrichmentData issue = issuesByKey.get(link);
            statusMap.put(link, new JiraLinkStatusDataWrapper(issue));
        }
        return statusMap;
    }
}

