/*
 * Decompiled with CFR 0.152.
 */
package com.radiantminds.roadmap.jira.common.components.extension.issues.data.progress;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.radiantminds.roadmap.common.extensions.workitems.ProgressData;
import com.radiantminds.roadmap.jira.common.components.extension.issues.data.hierarchy.HierarchicalJiraIssueData;
import com.radiantminds.roadmap.jira.common.components.extension.issues.data.progress.FullProgressCalculator;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

abstract class AbstractFullProgressCalculator
implements FullProgressCalculator {
    protected final HierarchicalJiraIssueData issueHierarchy;

    protected AbstractFullProgressCalculator(HierarchicalJiraIssueData issueHierarchy) {
        this.issueHierarchy = issueHierarchy;
    }

    @Override
    public Map<String, ProgressData> calculate() {
        HashMap fullProgressMap = Maps.newHashMap();
        Set<String> roots = this.issueHierarchy.getRoots();
        for (String root : roots) {
            Map<String, ProgressData> treeProgresses = this.traverseTree(root);
            fullProgressMap.putAll(treeProgresses);
        }
        return fullProgressMap;
    }

    private Map<String, ProgressData> traverseTree(String root) {
        HashMap treeMap = Maps.newHashMap();
        Set<String> subIssues = this.issueHierarchy.getSubIssues(root);
        for (String subIssue : subIssues) {
            Map<String, ProgressData> subTreeProgresses = this.traverseTree(subIssue);
            treeMap.putAll(subTreeProgresses);
        }
        ProgressData progress = this.createProgress(root, treeMap);
        treeMap.put(root, progress);
        return treeMap;
    }

    protected abstract ProgressData createProgress(String var1, Map<String, ProgressData> var2);

    Set<ProgressData> getChildProgresses(String root, Map<String, ProgressData> treeMap) {
        return Sets.newHashSet(Maps.filterKeys(treeMap, (Predicate)Predicates.in(this.issueHierarchy.getSubIssues(root))).values());
    }
}

