/*
 * Decompiled with CFR 0.152.
 */
package com.radiantminds.roadmap.jira.common.components.extension.issues.data.progress;

import com.google.common.collect.Sets;
import com.radiantminds.roadmap.common.extensions.workitems.ProgressData;
import com.radiantminds.roadmap.jira.common.components.extension.issues.data.progress.ExtensionLinkProgress;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.concurrent.Immutable;

@Immutable
abstract class ProgressUtils {
    private ProgressUtils() {
    }

    static ProgressData getCombinedProgress(Set<ProgressData> progresses, boolean parentDone, boolean percentageDoneIfStatusDone) {
        double donePercentage = parentDone && percentageDoneIfStatusDone ? 1.0 : ProgressUtils.computeDonePercentage(progresses);
        double totalSum = ProgressUtils.computeTotalSum(progresses);
        return new ExtensionLinkProgress(donePercentage, totalSum, parentDone);
    }

    public static ProgressData getCombinedProgress(Collection<ProgressData> childProgresses, ProgressData selfProgress, boolean percentageDoneIfStatusDone) {
        HashSet allProgresses = Sets.newHashSet(childProgresses);
        allProgresses.add(selfProgress);
        double donePercentage = selfProgress.isDone() && percentageDoneIfStatusDone ? 1.0 : ProgressUtils.computeDonePercentage(allProgresses);
        double totalSum = ProgressUtils.computeTotalSum(allProgresses);
        return new ExtensionLinkProgress(donePercentage, totalSum, selfProgress.isDone());
    }

    private static double computeDonePercentage(Set<ProgressData> allProgresses) {
        double totalSum = ProgressUtils.computeTotalSum(allProgresses);
        double doneSum = 0.0;
        for (ProgressData progress : allProgresses) {
            double sum = progress.getSum();
            doneSum += progress.getDonePercentage() * sum;
        }
        if (totalSum > 0.0) {
            return doneSum / totalSum;
        }
        return 0.0;
    }

    static double computeTotalSum(Set<ProgressData> allProgresses) {
        double sum = 0.0;
        for (ProgressData progress : allProgresses) {
            sum += progress.getSum();
        }
        return sum;
    }
}

