/*
 * Decompiled with CFR 0.152.
 */
package com.radiantminds.roadmap.jira.common.components.extension.issues.data.progress;

import com.google.common.base.Optional;
import com.radiantminds.roadmap.common.extensions.workitems.ProgressData;
import com.radiantminds.roadmap.jira.common.components.extension.issues.data.hierarchy.HierarchicalJiraIssueData;
import com.radiantminds.roadmap.jira.common.components.extension.issues.data.progress.AbstractFullProgressCalculator;
import com.radiantminds.roadmap.jira.common.components.extension.issues.data.progress.ExtensionLinkProgress;
import com.radiantminds.roadmap.jira.common.components.extension.issues.data.progress.FailSafeCustomFieldReader;
import com.radiantminds.roadmap.jira.common.components.extension.issues.data.progress.FullProgressCalculator;
import com.radiantminds.roadmap.jira.common.components.extension.issues.data.progress.ProgressUtils;
import com.radiantminds.roadmap.jira.common.components.extension.issues.data.progress.ResolutionBasedFullProgressExtractor;
import java.util.Map;
import java.util.Set;

public class ResolutionBasedStoryPointFullProgressCalculator
extends AbstractFullProgressCalculator {
    private final FailSafeCustomFieldReader customFieldReader;
    private final Map<String, ProgressData> resolutionBasedProgresses;

    ResolutionBasedStoryPointFullProgressCalculator(FailSafeCustomFieldReader customFieldReader, HierarchicalJiraIssueData issueHierarchy, Map<String, ProgressData> resolutionBasedProgresses) {
        super(issueHierarchy);
        this.customFieldReader = customFieldReader;
        this.resolutionBasedProgresses = resolutionBasedProgresses;
    }

    @Override
    protected ProgressData createProgress(String root, Map<String, ProgressData> progressMap) {
        Optional<Double> points = this.customFieldReader.getCustomFieldValueForIssueId(root);
        if (points.isPresent()) {
            return this.createEstimatedProgress(root, (Double)points.get(), progressMap);
        }
        return this.createNotEstimatedProgress(root, progressMap);
    }

    private ProgressData createEstimatedProgress(String root, double points, Map<String, ProgressData> progressMap) {
        Set<ProgressData> childProgresses = this.getChildProgresses(root, progressMap);
        if (childProgresses.isEmpty()) {
            return ExtensionLinkProgress.createValueBasedSelfProgress(this.issueHierarchy.getIssueData(root), points);
        }
        double childrenSum = ProgressUtils.computeTotalSum(childProgresses);
        ProgressData resolutionBasedProgress = this.resolutionBasedProgresses.get(root);
        ProgressData selfProgress = ExtensionLinkProgress.createValueBasedSelfProgress(this.issueHierarchy.getIssueData(root), points);
        if (childrenSum == 0.0) {
            return new ExtensionLinkProgress(resolutionBasedProgress.getDonePercentage(), selfProgress.getSum(), resolutionBasedProgress.isDone());
        }
        return ProgressUtils.getCombinedProgress(childProgresses, selfProgress, true);
    }

    private ProgressData createNotEstimatedProgress(String root, Map<String, ProgressData> treeMap) {
        Set<ProgressData> childProgresses = this.getChildProgresses(root, treeMap);
        if (childProgresses.isEmpty()) {
            return ExtensionLinkProgress.createValueBasedSelfProgress(this.issueHierarchy.getIssueData(root), null);
        }
        return ProgressUtils.getCombinedProgress(childProgresses, this.issueHierarchy.getIssueData(root).isDone(), true);
    }

    public static FullProgressCalculator createInstance(FailSafeCustomFieldReader storyPointReader, HierarchicalJiraIssueData issueHierarchy) {
        Map resolutionBasedFullProgresses = new ResolutionBasedFullProgressExtractor(issueHierarchy).calculate();
        return new ResolutionBasedStoryPointFullProgressCalculator(storyPointReader, issueHierarchy, resolutionBasedFullProgresses);
    }
}

