/*
 * Decompiled with CFR 0.152.
 */
package com.radiantminds.roadmap.jira.common.components.extension.issues.data.progress;

import com.atlassian.rm.common.bridges.agile.AgileNotAvailableException;
import com.atlassian.rm.common.bridges.agile.customfields.AgileCustomFieldNotAvailableException;
import com.google.common.base.Optional;
import com.google.common.collect.Maps;
import com.radiantminds.roadmap.common.extensions.workitems.ProgressData;
import com.radiantminds.roadmap.jira.common.components.extension.issues.data.hierarchy.JiraLinkEnrichmentData;
import com.radiantminds.roadmap.jira.common.components.extension.issues.data.hierarchy.RetrievedJiraIssue;
import com.radiantminds.roadmap.jira.common.components.extension.issues.data.progress.ExtensionLinkProgress;
import com.radiantminds.roadmap.jira.common.components.extension.issues.data.progress.FailSafeCustomFieldReader;
import com.radiantminds.roadmap.jira.common.components.extension.issues.data.progress.SelfProgressExtractor;
import com.radiantminds.roadmap.jira.common.components.utils.customfields.CustomFields;
import java.util.HashMap;
import java.util.Map;

class ResolutionBasedStoryPointSelfProgressExtractor
implements SelfProgressExtractor {
    private final FailSafeCustomFieldReader fieldReader;

    ResolutionBasedStoryPointSelfProgressExtractor(FailSafeCustomFieldReader fieldReader) {
        this.fieldReader = fieldReader;
    }

    @Override
    public Map<String, ProgressData> getProgressData(Map<String, JiraLinkEnrichmentData> statusData) {
        HashMap progressMap = Maps.newHashMap();
        for (Map.Entry<String, JiraLinkEnrichmentData> entry : statusData.entrySet()) {
            JiraLinkEnrichmentData status = entry.getValue();
            Double fieldValue = (Double)this.fieldReader.getCustomFieldValueForIssueId(entry.getKey()).orNull();
            ProgressData timeSelfProgress = ExtensionLinkProgress.createResolutionSelfProgress(status);
            ExtensionLinkProgress selfProgress = new ExtensionLinkProgress(timeSelfProgress.getDonePercentage(), (Double)Optional.fromNullable((Object)fieldValue).or((Object)0.0), timeSelfProgress.isDone());
            progressMap.put(entry.getKey(), selfProgress);
        }
        return progressMap;
    }

    static SelfProgressExtractor createInstance(CustomFields customFields, Map<String, RetrievedJiraIssue> issues) throws AgileNotAvailableException, AgileCustomFieldNotAvailableException {
        return new ResolutionBasedStoryPointSelfProgressExtractor(FailSafeCustomFieldReader.createStoryPointReader(customFields, issues));
    }
}

