/*
 * Decompiled with CFR 0.152.
 */
package com.radiantminds.roadmap.jira.common.components.extension.issues.links;

import com.atlassian.jira.bc.issue.link.IssueLinkService;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.MutableIssue;
import com.atlassian.jira.issue.link.Direction;
import com.atlassian.jira.issue.link.IssueLink;
import com.atlassian.jira.issue.link.IssueLinkType;
import com.atlassian.jira.issue.link.IssueLinkTypeManager;
import com.atlassian.jira.issue.link.LinkCollection;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.rm.common.bridges.jira.issue.link.IssueLinkServiceBridge;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.radiantminds.roadmap.jira.common.components.extension.issues.links.exceptions.InvalidIssueLinkTypeException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class IssueLinkUtils {
    public static final String ISSUE_NOT_FOUND_VIOLATION = "jira-issue-linking-issue-not-found";
    public static final String ISSUE_LINKING_DISABLED_VIOLATION = "jira-issue-linking-disabled";
    public static final String ISSUE_LINK_TYPE_UNKNOWN_VIOLATION = "jira-issue-linking-invalid-type";
    public static final String MISSING_ISSUE_LINK_PERMISSION_FOR_PROJECT = "jira-issue-linking-not-allowed-in-project";

    public static IssueLinkType getIssueLinkType(IssueLinkTypeManager issueLinkTypeManager, String issueLinkTypeId) throws InvalidIssueLinkTypeException {
        Long numericIssueLinkTypeId;
        try {
            numericIssueLinkTypeId = Long.parseLong(issueLinkTypeId);
        }
        catch (NumberFormatException nfe) {
            throw new InvalidIssueLinkTypeException();
        }
        IssueLinkType linkType = issueLinkTypeManager.getIssueLinkType(numericIssueLinkTypeId, false);
        if (linkType == null) {
            throw new InvalidIssueLinkTypeException();
        }
        return linkType;
    }

    public static Set<String> createIssueLinks(IssueLinkServiceBridge issueLinkServiceBridge, ApplicationUser user, MutableIssue issue, IssueLinkType issueLinkType, Direction linkDirection, List<String> linkKeys) {
        HashSet errorMessages = Sets.newHashSet();
        IssueLinkService.AddIssueLinkValidationResult validationResult = issueLinkServiceBridge.validateAddIssueLinks(user, (Issue)issue, issueLinkType.getId(), linkDirection, linkKeys, false);
        if (validationResult.isValid()) {
            issueLinkServiceBridge.addIssueLinks(user, validationResult);
        } else {
            errorMessages.addAll(validationResult.getErrorCollection().getErrorMessages());
        }
        return errorMessages;
    }

    public static Set<String> deleteIssueLinks(IssueLinkService issueLinkService, IssueLinkServiceBridge issueLinkServiceBridge, ApplicationUser user, MutableIssue issue, IssueLinkType issueLinkType) {
        HashSet errorMessages = Sets.newHashSet();
        IssueLinkService.IssueLinkResult getIssueLinksResult = issueLinkServiceBridge.getIssueLinks(user, (Issue)issue);
        if (!getIssueLinksResult.isValid()) {
            errorMessages.addAll(getIssueLinksResult.getErrorCollection().getErrorMessages());
            return errorMessages;
        }
        LinkCollection issueLinks = getIssueLinksResult.getLinkCollection();
        List inwardIssues = issueLinks.getInwardIssues(issueLinkType.getName());
        List outwardIssues = issueLinks.getOutwardIssues(issueLinkType.getName());
        if (inwardIssues == null) {
            inwardIssues = Lists.newArrayList();
        }
        if (outwardIssues == null) {
            outwardIssues = Lists.newArrayList();
        }
        errorMessages.addAll(IssueLinkUtils.deleteIssueLinksOfType(issueLinkService, issueLinkServiceBridge, issue, user, inwardIssues, issueLinkType));
        errorMessages.addAll(IssueLinkUtils.deleteIssueLinksOfType(issueLinkService, issueLinkServiceBridge, issue, user, outwardIssues, issueLinkType));
        return errorMessages;
    }

    public static final Direction getInvertedIssueLinkDirection(Direction direction) {
        if (Direction.IN == direction) {
            return Direction.OUT;
        }
        if (Direction.OUT == direction) {
            return Direction.IN;
        }
        return direction;
    }

    private static final List<String> deleteIssueLinksOfType(IssueLinkService issueLinkService, IssueLinkServiceBridge issueLinkServiceBridge, MutableIssue sourceIssue, ApplicationUser user, List<Issue> targetIssues, IssueLinkType issueLinkType) {
        ArrayList errorMessages = Lists.newArrayList();
        for (Issue inwardIssue : targetIssues) {
            IssueLink link = issueLinkService.getIssueLink(sourceIssue.getId(), inwardIssue.getId(), issueLinkType.getId());
            if (link == null) continue;
            IssueLinkService.DeleteIssueLinkValidationResult deleteResult = issueLinkServiceBridge.validateDelete(user, (Issue)sourceIssue, link);
            if (deleteResult.isValid()) {
                issueLinkService.delete(deleteResult);
                continue;
            }
            errorMessages.addAll(deleteResult.getErrorCollection().getErrorMessages());
        }
        return errorMessages;
    }
}

