/*
 * Decompiled with CFR 0.152.
 */
package com.radiantminds.roadmap.jira.common.components.extension.issues.sync.jpo2jira;

import com.google.common.base.Optional;
import com.radiantminds.roadmap.common.data.common.DataMode;
import com.radiantminds.roadmap.common.data.entities.common.IExtensionLink;
import com.radiantminds.roadmap.common.data.entities.workitems.IEstimateBlock;
import com.radiantminds.roadmap.common.data.persistence.common.entitypersistence.SyncInformation;
import com.radiantminds.roadmap.common.extensions.issues.IssueSyncData;
import com.radiantminds.roadmap.jira.common.components.extension.issues.sync.jpo2jira.PortfolioToJiraSyncConfiguration;
import java.util.List;
import java.util.Map;

class PortfolioToJiraSyncData {
    private final String id;
    private final Optional<String> title;
    private final Optional<String> description;
    private final Optional<IEstimateBlock> remainingEstimates;
    private final Optional<IEstimateBlock> originalEstimates;
    private final List<IExtensionLink> extensionLinks;

    private PortfolioToJiraSyncData(String id, Optional<String> title, Optional<String> description, Optional<IEstimateBlock> remainingEstimates, Optional<IEstimateBlock> originalEstimates, List<IExtensionLink> extensionLinks) {
        this.id = id;
        this.title = title;
        this.description = description;
        this.remainingEstimates = remainingEstimates;
        this.originalEstimates = originalEstimates;
        this.extensionLinks = extensionLinks;
    }

    public String getId() {
        return this.id;
    }

    public Optional<String> getTitle() {
        return this.title;
    }

    public Optional<String> getDescription() {
        return this.description;
    }

    public List<IExtensionLink> getExtensionLinks() {
        return this.extensionLinks;
    }

    public Optional<IEstimateBlock> getRemainingEstimates() {
        return this.remainingEstimates;
    }

    public Optional<IEstimateBlock> getOriginalEstimates() {
        return this.originalEstimates;
    }

    public static PortfolioToJiraSyncData create(PortfolioToJiraSyncConfiguration syncConfiguration, IssueSyncData issueSyncData, Map<DataMode, IEstimateBlock> estimates, SyncInformation syncInformation) {
        Optional<String> title = syncConfiguration.isSyncTitle() ? issueSyncData.getTitle() : Optional.absent();
        Optional<String> description = syncConfiguration.isSyncDescription() ? issueSyncData.getDescription() : Optional.absent();
        IEstimateBlock remainingEstimates = null;
        IEstimateBlock originalEstimates = null;
        if (estimates != null) {
            remainingEstimates = estimates.get((Object)DataMode.Default);
            originalEstimates = estimates.get((Object)DataMode.Original);
        }
        return new PortfolioToJiraSyncData(issueSyncData.getId(), title, description, (Optional<IEstimateBlock>)Optional.fromNullable((Object)remainingEstimates), (Optional<IEstimateBlock>)Optional.fromNullable((Object)originalEstimates), syncInformation.getExtensionLinks());
    }
}

