/*
 * Decompiled with CFR 0.152.
 */
package com.radiantminds.roadmap.jira.common.components.issues;

import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.pocketknife.api.logging.Log;
import com.atlassian.pocketknife.api.querydsl.ConnectionProvider;
import com.google.common.base.Optional;
import com.google.common.collect.Lists;
import com.radiantminds.roadmap.common.data.entities.common.IExtensionLink;
import com.radiantminds.roadmap.common.data.entities.plans.IPlanConfiguration;
import com.radiantminds.roadmap.common.data.entities.workitems.IWorkItem;
import com.radiantminds.roadmap.common.data.persistence.ao.entities.workitems.workitem.AOWorkItem;
import com.radiantminds.roadmap.common.data.persistence.common.entitypersistence.EntityInfo;
import com.radiantminds.roadmap.common.data.persistence.common.entitypersistence.PortfolioEstimatePersistence;
import com.radiantminds.roadmap.common.data.persistence.common.entitypersistence.PortfolioExtensionLinkPersistence;
import com.radiantminds.roadmap.common.data.persistence.common.entitypersistence.PortfolioWorkItemPersistence;
import com.radiantminds.roadmap.common.data.persistence.services.PortfolioPlanPersistence;
import com.radiantminds.roadmap.common.extensions.workitems.WorkItemExtension;
import com.radiantminds.roadmap.jira.common.components.extension.issues.sync.LinkUtils;
import com.radiantminds.roadmap.jira.common.components.issues.IssueFieldChanges;
import com.radiantminds.roadmap.jira.common.components.issues.JiraIssueLinkAccessor;
import com.radiantminds.roadmap.jira.common.components.issues.sync.JiraToPortfolioSyncHandler;
import com.radiantminds.roadmap.jira.common.components.issues.sync.SyncTask;
import com.radiantminds.roadmap.jira.common.components.sync.SynchronizationFlagHandler;
import com.radiantminds.roadmap.jira.common.components.utils.JiraSyncUtil;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.List;

public class JiraIssueSynchronizer {
    private static final Log LOGGER = Log.with(JiraIssueSynchronizer.class);
    private final SynchronizationFlagHandler flagHandler;
    private final ConnectionProvider connectionProvider;
    private final PortfolioWorkItemPersistence workItemPersistence;
    private final PortfolioEstimatePersistence estimatePersistence;
    private final PortfolioExtensionLinkPersistence extensionLinkPersistence;
    private final PortfolioPlanPersistence planPersistence;
    private final WorkItemExtension workItemExtension;
    private final ApplicationProperties applicationProperties;
    private final JiraIssueLinkAccessor jiraIssueLinkAccessor;
    private final JiraSyncUtil jiraSyncUtil;

    public JiraIssueSynchronizer(SynchronizationFlagHandler flagHandler, ConnectionProvider connectionProvider, PortfolioWorkItemPersistence workItemPersistence, PortfolioEstimatePersistence estimatePersistence, PortfolioPlanPersistence planPersistence, PortfolioExtensionLinkPersistence extensionLinkPersistence, WorkItemExtension workItemExtension, ApplicationProperties applicationProperties, JiraIssueLinkAccessor jiraIssueLinkAccessor, JiraSyncUtil jiraSyncUtil) {
        this.flagHandler = flagHandler;
        this.connectionProvider = connectionProvider;
        this.workItemPersistence = workItemPersistence;
        this.estimatePersistence = estimatePersistence;
        this.planPersistence = planPersistence;
        this.extensionLinkPersistence = extensionLinkPersistence;
        this.workItemExtension = workItemExtension;
        this.applicationProperties = applicationProperties;
        this.jiraIssueLinkAccessor = jiraIssueLinkAccessor;
        this.jiraSyncUtil = jiraSyncUtil;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onJiraIssueUpdated(String issueKey, IssueFieldChanges changes) throws Exception {
        if (this.flagHandler.isJiraUpdateOngoing()) {
            return;
        }
        List<String> workItemIds = this.jiraIssueLinkAccessor.getWorkItemsForIssue(issueKey);
        ArrayList plansToIncrement = Lists.newArrayList();
        JiraToPortfolioSyncHandler syncHandler = new JiraToPortfolioSyncHandler(this.workItemPersistence, this.estimatePersistence, this.applicationProperties, this.workItemExtension, this.jiraSyncUtil, changes);
        if (changes.hasRelevantChanges()) {
            for (String workItemId : workItemIds) {
                IWorkItem item = (IWorkItem)this.workItemPersistence.get(workItemId);
                if (item == null) continue;
                EntityInfo entityInfo = this.workItemPersistence.getEntityInfo(item.getId());
                IPlanConfiguration planConfiguration = this.planPersistence.getPlanConfiguration(entityInfo.getPlanId());
                boolean modified = false;
                Optional<Integer> stageId = Optional.absent();
                List<IExtensionLink> allLinks = this.extensionLinkPersistence.getLinksForTarget(AOWorkItem.class, workItemId);
                for (IExtensionLink link : allLinks) {
                    if (!link.getExtensionLink().equals(issueKey)) continue;
                    stageId = LinkUtils.getStageIdFromLink(link.getExtensionKey());
                }
                for (SyncTask task : syncHandler.getSyncTasks(item, planConfiguration, stageId)) {
                    modified |= task.apply(item);
                }
                if (!modified) continue;
                LOGGER.debug("Syncing Jira issue '" + issueKey + "' to '" + item.getTitle() + "'", new Object[0]);
                if (!plansToIncrement.contains(entityInfo.getPlanId())) {
                    plansToIncrement.add(entityInfo.getPlanId());
                }
                this.workItemPersistence.persistSilent(item);
            }
            Connection connection = this.connectionProvider.borrowConnection();
            try {
                for (String planId : plansToIncrement) {
                    this.planPersistence.incrementVersions(connection, planId, true, true);
                }
                connection.commit();
            }
            finally {
                this.connectionProvider.returnConnection(connection);
            }
        }
    }
}

