/*
 * Decompiled with CFR 0.152.
 */
package org.javasimon.callback.quantiles;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.javasimon.Split;
import org.javasimon.callback.logging.LogMessageSource;
import org.javasimon.callback.logging.LogTemplate;
import org.javasimon.callback.logging.LogTemplates;
import org.javasimon.callback.quantiles.Bucket;
import org.javasimon.callback.quantiles.BucketSample;
import org.javasimon.callback.quantiles.BucketsSample;
import org.javasimon.utils.SimonUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Buckets
implements LogMessageSource<Split> {
    protected final Bucket[] buckets;
    protected final int bucketNb;
    protected final long min;
    protected final long max;
    private LogTemplate<Split> logTemplate = LogTemplates.disabled();

    public Buckets(long min, long max, int bucketNb) {
        if (bucketNb < 3) {
            throw new IllegalArgumentException("Expected at least 3 buckets: " + bucketNb);
        }
        if (min >= max) {
            throw new IllegalArgumentException("Expected min<max: " + min + "/" + max);
        }
        this.min = min;
        this.max = max;
        this.bucketNb = bucketNb;
        this.buckets = new Bucket[bucketNb + 2];
        this.buckets[0] = new Bucket(Long.MIN_VALUE, min);
        this.buckets[bucketNb + 1] = new Bucket(max, Long.MAX_VALUE);
    }

    private int checkAndGetTotalCount() throws IllegalStateException {
        int usedBuckets = 0;
        int totalCount = this.buckets[0].getCount();
        for (int i = 1; i <= this.bucketNb; ++i) {
            int bucketCount = this.buckets[i].getCount();
            totalCount += bucketCount;
            if (bucketCount <= 0) continue;
            ++usedBuckets;
        }
        totalCount += this.buckets[this.bucketNb + 1].getCount();
        if (usedBuckets < 3) {
            throw new IllegalStateException("Only " + usedBuckets + " buckets used, not enough for interpolation, consider reconfiguring min/max/nb");
        }
        return totalCount;
    }

    private double computeQuantile(double ration, int totalCount) throws IllegalStateException, IllegalArgumentException {
        if (ration <= 0.0 || ration >= 1.0) {
            throw new IllegalArgumentException("Expected ratio between 0 and 1 excluded: " + ration);
        }
        double expectedCount = ration * (double)totalCount;
        double lastCount = 0.0;
        int bucketIndex = 0;
        for (int i = 0; i < this.buckets.length; ++i) {
            double newCount = lastCount + (double)this.buckets[i].getCount();
            if (expectedCount >= lastCount && expectedCount < newCount) {
                bucketIndex = i;
                break;
            }
            lastCount = newCount;
        }
        if (bucketIndex == 0) {
            throw new IllegalStateException("Quantile out of bounds: decrease min");
        }
        if (bucketIndex == this.bucketNb + 1) {
            throw new IllegalStateException("Quantile out of bounds: increase max");
        }
        Bucket bucket = this.buckets[bucketIndex];
        return this.estimateQuantile(bucket, expectedCount, lastCount);
    }

    protected double estimateQuantile(Bucket bucket, double expectedCount, double lastCount) {
        return (double)bucket.getMin() + (expectedCount - lastCount) * (double)(bucket.getMax() - bucket.getMin()) / (double)bucket.getCount();
    }

    protected Bucket getBucketForValue(long value) {
        for (Bucket bucket : this.buckets) {
            if (!bucket.contains(value)) continue;
            return bucket;
        }
        throw new IllegalStateException("Non continuous buckets.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addValue(long value) {
        Bucket[] bucketArray = this.buckets;
        synchronized (this.buckets) {
            this.getBucketForValue(value).incrementCount();
            // ** MonitorExit[var3_2] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addValues(Collection<Long> values) {
        Bucket[] bucketArray = this.buckets;
        synchronized (this.buckets) {
            for (Long value : values) {
                this.addValue(value);
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double getQuantile(double ratio) {
        Bucket[] bucketArray = this.buckets;
        synchronized (this.buckets) {
            int totalCount = this.checkAndGetTotalCount();
            // ** MonitorExit[var3_2] (shouldn't be in output)
            return this.computeQuantile(ratio, totalCount);
        }
    }

    public double getMedian() {
        return this.getQuantile(0.5);
    }

    public Double[] getQuartiles() {
        return this.getQuantiles(0.25, 0.5, 0.75);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Double[] getQuantiles(double ... ratios) {
        Bucket[] bucketArray = this.buckets;
        synchronized (this.buckets) {
            Double[] quantiles = new Double[ratios.length];
            try {
                int totalCount = this.checkAndGetTotalCount();
                for (int i = 0; i < ratios.length; ++i) {
                    try {
                        quantiles[i] = this.computeQuantile(ratios[i], totalCount);
                        continue;
                    }
                    catch (IllegalStateException e) {
                        // empty catch block
                    }
                }
            }
            catch (IllegalStateException e) {
                // empty catch block
            }
            return quantiles;
        }
    }

    public LogTemplate<Split> getLogTemplate() {
        return this.logTemplate;
    }

    public void setLogTemplate(LogTemplate<Split> logTemplate) {
        this.logTemplate = logTemplate;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BucketsSample sample() {
        Bucket[] bucketArray = this.buckets;
        synchronized (this.buckets) {
            BucketSample[] bucketSamples = new BucketSample[this.buckets.length];
            for (int i = 0; i < this.buckets.length; ++i) {
                bucketSamples[i] = this.buckets[i].sample();
            }
            Double[] quantiles = this.getQuantiles(0.5, 0.9);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return new BucketsSample(bucketSamples, quantiles[0], quantiles[1]);
        }
    }

    public String toString() {
        return this.toString(false);
    }

    private String toString(boolean bars) {
        StringBuilder stringBuilder = new StringBuilder("Buckets[");
        stringBuilder.append("min=").append(SimonUtils.presentNanoTime(this.min)).append(",max=").append(SimonUtils.presentNanoTime(this.max)).append(",nb=").append(this.bucketNb).append("] Quantiles[");
        String eol = System.getProperty("line.separator");
        String eoc = "\t";
        BucketsSample bucketsSample = this.sample();
        if (bucketsSample.getMedian() != null) {
            stringBuilder.append("median=").append(SimonUtils.presentNanoTime(bucketsSample.getMedian()));
        }
        if (bucketsSample.getPercentile90() != null) {
            stringBuilder.append(",90%=").append(SimonUtils.presentNanoTime(bucketsSample.getPercentile90()));
        }
        stringBuilder.append("]");
        if (bars) {
            stringBuilder.append(eol);
            int maxCount = 0;
            int barMax = 10;
            for (BucketSample bucketSample : bucketsSample.getBuckets()) {
                maxCount = Math.max(maxCount, bucketSample.getCount());
            }
            for (BucketSample bucketSample : bucketsSample.getBuckets()) {
                if (bucketSample.getMin() != Long.MIN_VALUE) {
                    stringBuilder.append(SimonUtils.presentNanoTime(bucketSample.getMin()));
                }
                stringBuilder.append("\t");
                if (bucketSample.getMax() != Long.MAX_VALUE) {
                    stringBuilder.append(SimonUtils.presentNanoTime(bucketSample.getMax()));
                }
                stringBuilder.append("\t").append(bucketSample.getCount()).append("\t");
                if (maxCount > 0) {
                    int barSize = bucketSample.getCount() * 10 / maxCount;
                    for (int i = 0; i < barSize; ++i) {
                        stringBuilder.append('#');
                    }
                }
                stringBuilder.append(eol);
            }
        }
        return stringBuilder.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        Bucket[] bucketArray = this.buckets;
        synchronized (this.buckets) {
            for (Bucket bucket : this.buckets) {
                bucket.clear();
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    public List<Bucket> getBuckets() {
        return Collections.unmodifiableList(Arrays.asList(this.buckets));
    }

    @Override
    public String getLogMessage(Split lastSplit) {
        return lastSplit.getStopwatch().getName() + " " + this.toString(true);
    }

    public void log(Split lastSplit) {
        this.logTemplate.log(lastSplit, this);
    }

    public int getBucketNb() {
        return this.bucketNb;
    }

    public long getMin() {
        return this.min;
    }

    public long getMax() {
        return this.max;
    }
}

