/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.pocketknife.spi.querydsl;

import com.atlassian.fugue.Option;
import com.atlassian.pocketknife.internal.querydsl.SchemaProviderAccessor;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.mysema.query.sql.ColumnMetadata;
import com.mysema.query.sql.PrimaryKey;
import com.mysema.query.sql.RelationalPathBase;
import com.mysema.query.sql.SchemaAndTable;
import com.mysema.query.types.Path;
import com.mysema.query.types.path.BooleanPath;
import com.mysema.query.types.path.DatePath;
import com.mysema.query.types.path.DateTimePath;
import com.mysema.query.types.path.NumberPath;
import com.mysema.query.types.path.StringPath;
import com.mysema.query.types.path.TimePath;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class EnhancedRelationalPathBase<T>
extends RelationalPathBase<T> {
    private static final Logger log = LoggerFactory.getLogger(EnhancedRelationalPathBase.class);

    public EnhancedRelationalPathBase(Class<? extends T> type, String tableName) {
        super(type, EnhancedRelationalPathBase.dbTableName(tableName), EnhancedRelationalPathBase.dbSchemaName(EnhancedRelationalPathBase.dbTableName(tableName)), EnhancedRelationalPathBase.dbTableName(tableName));
    }

    private static String dbTableName(String logicalTableName) {
        Preconditions.checkNotNull((Object)logicalTableName, (Object)"You must supply a non null logicalTableName");
        String tableName = SchemaProviderAccessor.getSchemaProvider().getTableName(logicalTableName);
        return EnhancedRelationalPathBase.defaultedDef(tableName, logicalTableName, "table:" + logicalTableName);
    }

    private String dbColumnName(String logicalColumnName) {
        Preconditions.checkNotNull((Object)logicalColumnName, (Object)"You must supply a non null logicalColumnName");
        String tableName = this.getTableName();
        String columnName = SchemaProviderAccessor.getSchemaProvider().getColumnName(tableName, logicalColumnName);
        return EnhancedRelationalPathBase.defaultedDef(columnName, logicalColumnName, "column:" + tableName + "." + logicalColumnName);
    }

    private static String defaultedDef(String physical, String logical, String targetName) {
        Option dbObj = Option.option((Object)physical);
        if (dbObj.isEmpty()) {
            log.warn(String.format("Could not find the physical database object for the logically named '%s'. Is this expected database state?", targetName));
        }
        return (String)dbObj.getOrElse((Object)logical);
    }

    private static String dbSchemaName(String logicalTableName) {
        return SchemaProviderAccessor.getSchemaProvider().getSchema(logicalTableName);
    }

    @Override
    public SchemaAndTable getSchemaAndTable() {
        return new SchemaAndTable(this.getSchemaName(), this.getTableName());
    }

    @Override
    protected BooleanPath createBoolean(String columnName) {
        String dbColumnName = this.dbColumnName(columnName);
        BooleanPath path = super.createBoolean(dbColumnName);
        this.addMetadata(path, ColumnMetadata.named(dbColumnName).ofType(16));
        return path;
    }

    @Override
    protected <A extends Comparable> DatePath<A> createDate(String columnName, Class<? super A> type) {
        String dbColumnName = this.dbColumnName(columnName);
        DatePath<? super A> path = super.createDate(dbColumnName, type);
        this.addMetadata(path, ColumnMetadata.named(dbColumnName).ofType(91));
        return path;
    }

    @Override
    protected <A extends Comparable> DateTimePath<A> createDateTime(String columnName, Class<? super A> type) {
        String dbColumnName = this.dbColumnName(columnName);
        DateTimePath<? super A> path = super.createDateTime(dbColumnName, type);
        this.addMetadata(path, ColumnMetadata.named(dbColumnName).ofType(93));
        return path;
    }

    @Override
    protected <A extends Number> NumberPath<A> createNumber(String columnName, Class<? super A> type) {
        String dbColumnName = this.dbColumnName(columnName);
        NumberPath<? super A> path = super.createNumber(dbColumnName, type);
        this.addMetadata(path, ColumnMetadata.named(dbColumnName).ofType(this.mapJavaNumberType(type)));
        return path;
    }

    protected NumberPath<Integer> createInteger(String columnName) {
        String dbColumnName = this.dbColumnName(columnName);
        NumberPath<Integer> path = super.createNumber(dbColumnName, Integer.class);
        this.addMetadata(path, ColumnMetadata.named(dbColumnName).ofType(4));
        return path;
    }

    protected NumberPath<Long> createLong(String columnName) {
        String dbColumnName = this.dbColumnName(columnName);
        NumberPath<Long> path = super.createNumber(dbColumnName, Long.class);
        this.addMetadata(path, ColumnMetadata.named(dbColumnName).ofType(-5));
        return path;
    }

    protected NumberPath<Double> createDouble(String columnName) {
        String dbColumnName = this.dbColumnName(columnName);
        NumberPath<Double> path = super.createNumber(dbColumnName, Double.class);
        this.addMetadata(path, ColumnMetadata.named(dbColumnName).ofType(8));
        return path;
    }

    protected NumberPath<BigDecimal> createBigDecimal(String columnName) {
        String dbColumnName = this.dbColumnName(columnName);
        NumberPath<BigDecimal> path = super.createNumber(dbColumnName, BigDecimal.class);
        this.addMetadata(path, ColumnMetadata.named(dbColumnName).ofType(3));
        return path;
    }

    protected NumberPath<Float> createFloat(String columnName) {
        String dbColumnName = this.dbColumnName(columnName);
        NumberPath<Float> path = super.createNumber(dbColumnName, Float.class);
        this.addMetadata(path, ColumnMetadata.named(dbColumnName).ofType(3));
        return path;
    }

    @Override
    protected StringPath createString(String columnName) {
        String dbColumnName = this.dbColumnName(columnName);
        StringPath path = super.createString(dbColumnName);
        this.addMetadata(path, ColumnMetadata.named(dbColumnName).ofType(12));
        return path;
    }

    @Override
    protected <A extends Comparable> TimePath<A> createTime(String columnName, Class<? super A> type) {
        String dbColumnName = this.dbColumnName(columnName);
        TimePath<? super A> path = super.createTime(dbColumnName, type);
        this.addMetadata(path, ColumnMetadata.named(dbColumnName).ofType(92));
        return path;
    }

    protected ColumnWithMetadataBuilder<BooleanPath> createBooleanCol(String columnName) {
        String dbColumnName = this.dbColumnName(columnName);
        BooleanPath path = super.createBoolean(dbColumnName);
        return new ColumnWithMetadataBuilder(this, (Path)path, ColumnMetadata.named(dbColumnName).ofType(16));
    }

    protected <A extends Comparable> ColumnWithMetadataBuilder<DatePath<A>> createDateCol(String columnName, Class<? super A> type) {
        String dbColumnName = this.dbColumnName(columnName);
        DatePath<? super A> path = super.createDate(dbColumnName, type);
        return new ColumnWithMetadataBuilder(this, path, ColumnMetadata.named(dbColumnName).ofType(91));
    }

    protected <A extends Comparable> ColumnWithMetadataBuilder<DateTimePath<A>> createDateTimeCol(String columnName, Class<? super A> type) {
        String dbColumnName = this.dbColumnName(columnName);
        DateTimePath<? super A> path = super.createDateTime(dbColumnName, type);
        return new ColumnWithMetadataBuilder(this, path, ColumnMetadata.named(dbColumnName).ofType(93));
    }

    protected <A extends Number> ColumnWithMetadataBuilder<NumberPath<A>> createNumberCol(String columnName, Class<? super A> type) {
        String dbColumnName = this.dbColumnName(columnName);
        NumberPath<? super A> path = super.createNumber(dbColumnName, type);
        return new ColumnWithMetadataBuilder(this, path, ColumnMetadata.named(dbColumnName).ofType(this.mapJavaNumberType(type)));
    }

    protected ColumnWithMetadataBuilder<NumberPath<Integer>> createIntegerCol(String columnName) {
        String dbColumnName = this.dbColumnName(columnName);
        NumberPath<Integer> path = super.createNumber(dbColumnName, Integer.class);
        return new ColumnWithMetadataBuilder(this, path, ColumnMetadata.named(dbColumnName).ofType(4));
    }

    protected ColumnWithMetadataBuilder<NumberPath<Long>> createLongCol(String columnName) {
        String dbColumnName = this.dbColumnName(columnName);
        NumberPath<Long> path = super.createNumber(dbColumnName, Long.class);
        return new ColumnWithMetadataBuilder(this, path, ColumnMetadata.named(dbColumnName).ofType(-5));
    }

    protected ColumnWithMetadataBuilder<NumberPath<Double>> createDoubleCol(String columnName) {
        String dbColumnName = this.dbColumnName(columnName);
        NumberPath<Double> path = super.createNumber(dbColumnName, Double.class);
        return new ColumnWithMetadataBuilder(this, path, ColumnMetadata.named(dbColumnName).ofType(8));
    }

    protected ColumnWithMetadataBuilder<NumberPath<BigDecimal>> createBigDecimalCol(String columnName) {
        String dbColumnName = this.dbColumnName(columnName);
        NumberPath<BigDecimal> path = super.createNumber(dbColumnName, BigDecimal.class);
        return new ColumnWithMetadataBuilder(this, path, ColumnMetadata.named(dbColumnName).ofType(3));
    }

    protected ColumnWithMetadataBuilder<NumberPath<Float>> createFloatCol(String columnName) {
        String dbColumnName = this.dbColumnName(columnName);
        NumberPath<Float> path = super.createNumber(dbColumnName, Float.class);
        return new ColumnWithMetadataBuilder(this, path, ColumnMetadata.named(dbColumnName).ofType(3));
    }

    protected ColumnWithMetadataBuilder<StringPath> createStringCol(String columnName) {
        String dbColumnName = this.dbColumnName(columnName);
        StringPath path = super.createString(dbColumnName);
        return new ColumnWithMetadataBuilder(this, (Path)path, ColumnMetadata.named(dbColumnName).ofType(12));
    }

    protected <A extends Comparable> ColumnWithMetadataBuilder<TimePath<A>> createTimeCol(String columnName, Class<? super A> type) {
        String dbColumnName = this.dbColumnName(columnName);
        TimePath<? super A> path = super.createTime(dbColumnName, type);
        return new ColumnWithMetadataBuilder(this, path, ColumnMetadata.named(dbColumnName).ofType(92));
    }

    public Path<?>[] getAllNonPrimaryKeyColumns() {
        PrimaryKey primaryKey = this.getPrimaryKey();
        final List pkColumns = primaryKey != null && primaryKey.getLocalColumns() != null ? primaryKey.getLocalColumns() : Collections.emptyList();
        ArrayList columns = Lists.newArrayList((Iterable)Iterables.filter(this.getColumns(), (Predicate)new Predicate<Path<?>>(){

            public boolean apply(Path<?> input) {
                for (Path pkColumn : pkColumns) {
                    if (!pkColumn.equals(input)) continue;
                    return false;
                }
                return true;
            }
        }));
        return Lists.newArrayList((Iterable)columns).toArray(new Path[columns.size()]);
    }

    private int mapJavaNumberType(Class<?> javaType) {
        if (javaType.equals(Integer.class)) {
            return 4;
        }
        if (javaType.equals(Long.class)) {
            return -5;
        }
        if (javaType.equals(Double.class)) {
            return 8;
        }
        if (javaType.equals(Float.class)) {
            return 3;
        }
        throw new UnsupportedOperationException("Unable to map number class " + javaType + " to JDBC type");
    }

    public static class ColumnWithMetadataBuilder<P extends Path<?>> {
        private final P path;
        private ColumnMetadata metadata;
        private boolean asPK = false;
        final /* synthetic */ EnhancedRelationalPathBase this$0;

        public ColumnWithMetadataBuilder(P path, ColumnMetadata startingMetadata) {
            this.this$0 = var1_1;
            this.path = path;
            this.metadata = startingMetadata;
        }

        public ColumnWithMetadataBuilder<P> asPrimaryKey() {
            this.asPK = true;
            this.metadata = this.metadata.notNull();
            return this;
        }

        public ColumnWithMetadataBuilder<P> notNull() {
            this.metadata = this.metadata.notNull();
            return this;
        }

        public ColumnWithMetadataBuilder<P> ofType(int jdbcType) {
            this.metadata = this.metadata.ofType(jdbcType);
            return this;
        }

        public ColumnWithMetadataBuilder<P> withIndex(int index) {
            this.metadata = this.metadata.withIndex(index);
            return this;
        }

        public ColumnWithMetadataBuilder<P> withSize(int size) {
            this.metadata = this.metadata.withSize(size);
            return this;
        }

        public ColumnWithMetadataBuilder<P> withDigits(int decimalDigits) {
            this.metadata = this.metadata.withDigits(decimalDigits);
            return this;
        }

        public P build() {
            this.this$0.addMetadata(this.path, this.metadata);
            if (this.asPK) {
                PrimaryKey currentPK = this.this$0.getPrimaryKey();
                if (currentPK != null) {
                    throw new IllegalStateException("You have already set a primary key.  I am not sure you know what you are doing");
                }
                this.this$0.createPrimaryKey(new Path[]{this.path});
            }
            return this.path;
        }
    }
}

