/*
 * Decompiled with CFR 0.152.
 */
package com.radiantminds.roadmap.common.exported;

import com.google.common.base.Optional;
import com.radiantminds.roadmap.common.data.persistence.common.entitypersistence.PortfolioExtensionLinkPersistence;
import com.radiantminds.roadmap.common.data.persistence.common.entitypersistence.PortfolioStagePersistence;
import com.radiantminds.roadmap.common.data.persistence.common.entitypersistence.PortfolioWorkItemPersistence;
import com.radiantminds.roadmap.common.data.persistence.services.PortfolioPlanPersistence;
import com.radiantminds.roadmap.common.exported.SyncService;
import com.radiantminds.roadmap.common.extensions.analytics.AnalyticsExtension;
import com.radiantminds.roadmap.common.extensions.workitems.WorkItemExtension;
import com.radiantminds.roadmap.common.handlers.EntityContext;
import com.radiantminds.roadmap.common.handlers.SecuredInvocationHandlerFactory;
import com.radiantminds.roadmap.common.handlers.sync.SyncOperationResult;
import com.radiantminds.roadmap.common.handlers.sync.workitems.ValidatedWorkItemSyncConfiguration;
import com.radiantminds.roadmap.common.handlers.sync.workitems.WorkItemSyncConfiguration;
import com.radiantminds.roadmap.common.handlers.sync.workitems.WorkItemSyncServiceHandler;
import com.radiantminds.roadmap.common.handlers.sync.workitems.WorkItemSyncServiceHandlerImpl;
import com.radiantminds.roadmap.common.scheduling.Scheduling;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ExportedSyncService
implements SyncService {
    private final SecuredInvocationHandlerFactory handlerFactory;
    private final PortfolioPlanPersistence planPersistence;
    private final PortfolioWorkItemPersistence workItemPersistence;
    private final PortfolioStagePersistence stagePersistence;
    private final PortfolioExtensionLinkPersistence linkPersistence;
    private final AnalyticsExtension analyticsExtension;
    private final WorkItemExtension workItemExtension;
    private final Scheduling scheduling;

    @Autowired
    public ExportedSyncService(SecuredInvocationHandlerFactory handlerFactory, PortfolioPlanPersistence planPersistence, PortfolioWorkItemPersistence workItemPersistence, PortfolioStagePersistence stagePersistence, PortfolioExtensionLinkPersistence linkPersistence, AnalyticsExtension analyticsExtension, WorkItemExtension workItemExtension, Scheduling scheduling) {
        this.handlerFactory = handlerFactory;
        this.planPersistence = planPersistence;
        this.workItemPersistence = workItemPersistence;
        this.stagePersistence = stagePersistence;
        this.analyticsExtension = analyticsExtension;
        this.workItemExtension = workItemExtension;
        this.linkPersistence = linkPersistence;
        this.scheduling = scheduling;
    }

    @Override
    public SyncOperationResult syncWorkItems(String planId, WorkItemSyncConfiguration workItemSyncConfiguration) throws Exception {
        WorkItemSyncServiceHandler handler = this.handlerFactory.createProxy(WorkItemSyncServiceHandler.class, new WorkItemSyncServiceHandlerImpl(this.planPersistence, this.workItemPersistence, this.stagePersistence, this.linkPersistence, this.analyticsExtension, this.workItemExtension, this.scheduling), this.planPersistence);
        Optional<ValidatedWorkItemSyncConfiguration> validatedConfig = ValidatedWorkItemSyncConfiguration.tryCreate(workItemSyncConfiguration);
        EntityContext entityContext = EntityContext.from(planId);
        return handler.syncWorkitems(entityContext, (ValidatedWorkItemSyncConfiguration)validatedConfig.orNull());
    }
}

