/*
 * Decompiled with CFR 0.152.
 */
package com.radiantminds.roadmap.common.extensions.analytics;

import com.atlassian.rm.jpo.scheduling.util.RmUtils;
import com.google.common.collect.Maps;
import com.radiantminds.roadmap.common.data.entities.skills.SchedulingSkill;
import com.radiantminds.roadmap.common.data.entities.skills.SchedulingStage;
import com.radiantminds.roadmap.common.extensions.analytics.AnalyticsUtil;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

class ConfigurationStatistics {
    private final Map<SchedulingStage, Set<SchedulingSkill>> stageToSkills;

    public ConfigurationStatistics(Map<SchedulingStage, Set<SchedulingSkill>> map) {
        this.stageToSkills = map;
    }

    static ConfigurationStatistics create(List<? extends SchedulingStage> stages) {
        HashMap map = Maps.newHashMap();
        if (stages != null) {
            for (SchedulingStage schedulingStage : stages) {
                if (schedulingStage.getSkills() == null) continue;
                for (SchedulingSkill schedulingSkill : schedulingStage.getSkills()) {
                    RmUtils.addToKeyedSets(map, schedulingStage, schedulingSkill);
                }
            }
        }
        return new ConfigurationStatistics(map);
    }

    long getStageCount() {
        return this.stageToSkills.size();
    }

    long getSkillCount() {
        return AnalyticsUtil.count(this.stageToSkills.values());
    }

    public double getStdSkillPerStage() {
        return AnalyticsUtil.stdDev(this.stageToSkills.values());
    }
}

