/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.bc;

import com.atlassian.annotations.PublicApi;
import com.atlassian.jira.bc.ServiceResult;
import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.jira.util.SimpleErrorCollection;
import com.atlassian.jira.util.SimpleWarningCollection;
import com.atlassian.jira.util.WarningCollection;
import com.atlassian.jira.util.dbc.Assertions;
import java.io.Serializable;
import javax.annotation.Nonnull;

@PublicApi
public class ServiceResultImpl
implements ServiceResult,
Serializable {
    private static final long serialVersionUID = -4206122924974290538L;
    private final ErrorCollection errorCollection;
    private final WarningCollection warningCollection;

    public ServiceResultImpl() {
        this(new SimpleErrorCollection(), new SimpleWarningCollection());
    }

    public ServiceResultImpl(@Nonnull ErrorCollection errorCollection) {
        this(errorCollection, new SimpleWarningCollection());
    }

    public ServiceResultImpl(@Nonnull ErrorCollection errorCollection, @Nonnull WarningCollection warningCollection) {
        this.errorCollection = Assertions.notNull("errorCollection", errorCollection);
        this.warningCollection = Assertions.notNull("warningCollection", warningCollection);
    }

    private Object writeReplace() {
        return new ServiceResultImpl(new SimpleErrorCollection(this.errorCollection), new SimpleWarningCollection(this.warningCollection));
    }

    @Override
    public boolean isValid() {
        return !this.errorCollection.hasAnyErrors();
    }

    @Override
    public ErrorCollection getErrorCollection() {
        return this.errorCollection;
    }

    @Override
    public WarningCollection getWarningCollection() {
        return this.warningCollection;
    }
}

