/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.event.issue;

import com.atlassian.annotations.PublicApi;
import com.atlassian.jira.event.AbstractEvent;
import com.atlassian.jira.event.issue.IssueRelatedEvent;
import com.atlassian.jira.event.operation.SpanningOperation;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.user.ApplicationUser;
import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import java.util.Optional;
import javax.annotation.Nullable;

@PublicApi
public final class IssuePreDeleteEvent
extends AbstractEvent
implements IssueRelatedEvent {
    private final Issue issue;
    private final ApplicationUser user;
    private final SpanningOperation spanningOperation;

    public IssuePreDeleteEvent(Issue issue, ApplicationUser user) {
        this(issue, user, null);
    }

    public IssuePreDeleteEvent(Issue issue, ApplicationUser user, @Nullable SpanningOperation spanningOperation) {
        this.issue = issue;
        this.user = user;
        this.spanningOperation = spanningOperation;
    }

    @Override
    public Issue getIssue() {
        return this.issue;
    }

    public ApplicationUser getUser() {
        return this.user;
    }

    @Override
    public Optional<SpanningOperation> getSpanningOperation() {
        return Optional.ofNullable(this.spanningOperation);
    }

    @Override
    public boolean equals(Object o) {
        if (o instanceof IssuePreDeleteEvent) {
            IssuePreDeleteEvent that = (IssuePreDeleteEvent)o;
            return super.equals(that) && Objects.equal((Object)this.user, (Object)that.user) && Objects.equal((Object)this.issue, (Object)that.issue) && Objects.equal((Object)this.spanningOperation, (Object)that.spanningOperation);
        }
        return false;
    }

    @Override
    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{super.hashCode(), this.issue, this.user, this.spanningOperation});
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("time", (Object)this.time).add("params", (Object)this.params).add("issue", (Object)this.issue).add("user", (Object)this.user).add("spanningOperation", (Object)this.spanningOperation).toString();
    }
}

