/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.event.user;

import com.atlassian.annotations.ExperimentalApi;
import com.google.common.base.MoreObjects;
import java.util.Collections;
import java.util.Objects;
import java.util.Set;

@ExperimentalApi
public final class UsersAddedEvent {
    private final Set<AddedUser> addedUsers;

    public UsersAddedEvent(AddedUser addedUser) {
        this(Collections.singleton(addedUser));
    }

    public UsersAddedEvent(Set<AddedUser> addedUsers) {
        this.addedUsers = Collections.unmodifiableSet(addedUsers);
    }

    public Set<AddedUser> getAddedUsers() {
        return this.addedUsers;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UsersAddedEvent that = (UsersAddedEvent)o;
        return Objects.equals(this.addedUsers, that.addedUsers);
    }

    public int hashCode() {
        return Objects.hash(this.addedUsers);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("addedUsers", this.addedUsers).toString();
    }

    @ExperimentalApi
    public static final class AddedUser {
        private final String userKey;
        private final String emailAddress;

        public AddedUser(String userKey, String emailAddress) {
            this.userKey = userKey;
            this.emailAddress = emailAddress;
        }

        public String getUserKey() {
            return this.userKey;
        }

        public String getEmailAddress() {
            return this.emailAddress;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            AddedUser addedUser = (AddedUser)o;
            return Objects.equals(this.userKey, addedUser.userKey) && Objects.equals(this.emailAddress, addedUser.emailAddress);
        }

        public int hashCode() {
            return Objects.hash(this.userKey, this.emailAddress);
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("userKey", (Object)this.userKey).add("emailAddress", (Object)this.emailAddress).toString();
        }
    }
}

