/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.customfields.impl;

import com.atlassian.annotations.PublicSpi;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.context.IssueContext;
import com.atlassian.jira.issue.customfields.impl.AbstractCustomFieldType;
import com.atlassian.jira.issue.customfields.impl.FieldValidationException;
import com.atlassian.jira.issue.customfields.manager.GenericConfigManager;
import com.atlassian.jira.issue.customfields.persistence.CustomFieldValuePersister;
import com.atlassian.jira.issue.customfields.persistence.PersistenceFieldType;
import com.atlassian.jira.issue.customfields.view.CustomFieldParams;
import com.atlassian.jira.issue.fields.CustomField;
import com.atlassian.jira.issue.fields.config.FieldConfig;
import com.atlassian.jira.issue.fields.rest.json.JsonData;
import com.atlassian.jira.util.ErrorCollection;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.opensymphony.util.TextUtils;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.log4j.Logger;

@PublicSpi
public abstract class AbstractSingleFieldType<T>
extends AbstractCustomFieldType<T, T> {
    protected static final Logger log = Logger.getLogger(AbstractSingleFieldType.class);
    protected static final String FIELD_TYPE_STRING = "stringvalue";
    protected static final String FIELD_TYPE_TEXT = "textvalue";
    protected static final String FIELD_TYPE_DATE = "datevalue";
    protected static final String FIELD_TYPE_NUMBER = "numbervalue";
    protected final CustomFieldValuePersister customFieldValuePersister;
    protected final GenericConfigManager genericConfigManager;

    protected AbstractSingleFieldType(CustomFieldValuePersister customFieldValuePersister, GenericConfigManager genericConfigManager) {
        this.customFieldValuePersister = customFieldValuePersister;
        this.genericConfigManager = genericConfigManager;
    }

    @Override
    @Nullable
    public T getValueFromIssue(CustomField field, Issue issue) {
        return this.getValueFromIssue(field, issue.getId(), issue.getKey());
    }

    @Nullable
    protected T getValueFromIssue(@Nonnull CustomField field, @Nullable Long issueId, @Nullable String issueKey) {
        Object databaseValue;
        List<Object> values = this.customFieldValuePersister.getValues(field, issueId, this.getDatabaseType());
        if (values.isEmpty()) {
            return null;
        }
        if (values.size() > 1) {
            databaseValue = Iterables.getLast(values);
            log.warn((Object)("More than one value stored for custom field id '" + field.getId() + "' for issue '" + issueKey + "'. Keeping '" + databaseValue + "' (the newest value) and deleting other values. Original values:" + values));
            this.customFieldValuePersister.updateValues(field, issueId, this.getDatabaseType(), Collections.singletonList(databaseValue));
        } else {
            databaseValue = values.get(0);
        }
        if (databaseValue == null) {
            return null;
        }
        try {
            return this.getObjectFromDbValue(databaseValue);
        }
        catch (FieldValidationException e) {
            String message = "Issue " + issueKey + " has an invalid value '" + databaseValue + "' stored in the field '" + field.getName() + "'.";
            if (log.isDebugEnabled()) {
                log.debug((Object)message, (Throwable)e);
            } else {
                log.warn((Object)(message + " " + e.getMessage()));
            }
            return null;
        }
    }

    @Override
    public Set<Long> remove(CustomField field) {
        return this.customFieldValuePersister.removeAllValues(field.getId());
    }

    @Override
    public void createValue(CustomField field, Issue issue, @Nonnull T value) {
        this.customFieldValuePersister.createValues(field, issue.getId(), this.getDatabaseType(), Lists.newArrayList((Object[])new Object[]{this.getDbValueFromObject(value)}));
    }

    @Override
    public void updateValue(CustomField customField, Issue issue, T value) {
        this.customFieldValuePersister.updateValues(customField, issue.getId(), this.getDatabaseType(), Lists.newArrayList((Object[])new Object[]{this.getDbValueFromObject(value)}));
    }

    @Override
    public void setDefaultValue(FieldConfig fieldConfig, T value) {
        if (value == null) {
            this.genericConfigManager.remove("DefaultValue", fieldConfig.getId().toString());
        } else {
            this.genericConfigManager.update("DefaultValue", fieldConfig.getId().toString(), this.getDbValueFromObject(value));
        }
    }

    @Override
    public T getDefaultValue(FieldConfig fieldConfig) {
        try {
            if (fieldConfig == null) {
                return null;
            }
            Object databaseValue = this.genericConfigManager.retrieve("DefaultValue", fieldConfig.getId().toString());
            if (databaseValue != null) {
                return this.getObjectFromDbValue(databaseValue);
            }
            return null;
        }
        catch (FieldValidationException e) {
            log.error((Object)"Incorrect formatted custom field stored as default", (Throwable)e);
            return null;
        }
    }

    @Override
    public void validateFromParams(CustomFieldParams relevantParams, ErrorCollection errorCollectionToAddTo, FieldConfig config) {
        try {
            this.getValueFromCustomFieldParams(relevantParams);
        }
        catch (FieldValidationException e) {
            errorCollectionToAddTo.addError(config.getCustomField().getId(), e.getMessage(), ErrorCollection.Reason.VALIDATION_FAILED);
        }
    }

    @Override
    public T getValueFromCustomFieldParams(CustomFieldParams relevantParams) throws FieldValidationException {
        if (relevantParams == null) {
            return null;
        }
        Collection<String> normalParams = relevantParams.getValuesForKey(null);
        if (normalParams == null || normalParams.isEmpty()) {
            return null;
        }
        String singleParam = normalParams.iterator().next();
        if (TextUtils.stringSet((String)singleParam)) {
            return (T)this.getSingularObjectFromString(singleParam);
        }
        return null;
    }

    @Override
    public Object getStringValueFromCustomFieldParams(CustomFieldParams parameters) {
        return parameters.getFirstValueForNullKey();
    }

    @Override
    public String getChangelogValue(CustomField field, T value) {
        if (value == null) {
            return "";
        }
        return this.getStringFromSingularObject(value);
    }

    @Nonnull
    protected abstract PersistenceFieldType getDatabaseType();

    @Nullable
    protected abstract Object getDbValueFromObject(T var1);

    @Nullable
    protected abstract T getObjectFromDbValue(@Nonnull Object var1) throws FieldValidationException;

    @Override
    public Object accept(AbstractCustomFieldType.VisitorBase visitor) {
        if (visitor instanceof Visitor) {
            return ((Visitor)visitor).visitSingleField(this);
        }
        return super.accept(visitor);
    }

    public JsonData getJsonDefaultValue(IssueContext issueCtx, CustomField field) {
        FieldConfig config = field.getRelevantConfig(issueCtx);
        Object defaultValue = field.getCustomFieldType().getDefaultValue(config);
        return defaultValue == null ? null : new JsonData(defaultValue);
    }

    public static interface Visitor<X>
    extends AbstractCustomFieldType.VisitorBase<X> {
        public X visitSingleField(AbstractSingleFieldType var1);
    }
}

