/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.customfields.statistics;

import com.atlassian.annotations.Internal;
import com.atlassian.jira.issue.customfields.converters.SelectConverter;
import com.atlassian.jira.issue.customfields.impl.FieldValidationException;
import com.atlassian.jira.issue.customfields.option.Option;
import com.atlassian.jira.issue.customfields.statistics.CascadingOption;
import com.atlassian.jira.issue.customfields.statistics.CascadingOptionComparator;
import com.atlassian.jira.issue.fields.CustomField;
import com.atlassian.jira.issue.search.LuceneFieldSorter;
import com.atlassian.jira.util.dbc.Assertions;
import java.util.Comparator;

@Internal
public class CascadingOptionFieldSorter
implements LuceneFieldSorter<CascadingOption> {
    protected final CustomField customField;
    protected final SelectConverter selectConverter;

    public CascadingOptionFieldSorter(CustomField customField, SelectConverter selectConverter) {
        this.selectConverter = Assertions.notNull("selectConverter", selectConverter);
        this.customField = Assertions.notNull("customField", customField);
    }

    @Override
    public String getDocumentConstant() {
        return this.customField.getId() + "_combined";
    }

    @Override
    public CascadingOption getValueFromLuceneField(String documentValue) {
        if (documentValue == null || "".equals(documentValue)) {
            return null;
        }
        String[] valueSections = documentValue.split("\\|");
        switch (valueSections.length) {
            case 0: {
                return null;
            }
            case 1: {
                Option onlyParent = this.selectConverter.getObject(valueSections[0]);
                return new CascadingOption(onlyParent, null);
            }
            case 2: {
                Option parent = this.selectConverter.getObject(valueSections[0]);
                Option child = this.selectConverter.getObject(valueSections[1]);
                return new CascadingOption(parent, child);
            }
        }
        throw new FieldValidationException("Option Id '" + documentValue + "' is not a valid cascading select pair.");
    }

    @Override
    public Comparator<CascadingOption> getComparator() {
        return new CascadingOptionComparator();
    }
}

