/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.fields.rest.json.beans;

import com.atlassian.jira.issue.fields.rest.json.beans.JiraBaseUrls;
import com.atlassian.jira.issue.priority.Priority;
import com.atlassian.jira.util.JiraUrlCodec;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Lists;
import io.swagger.v3.oas.annotations.media.Schema;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;

@JsonIgnoreProperties(ignoreUnknown=true)
public class PriorityJsonBean {
    @JsonProperty
    @Schema(example="http://www.example.com/jira/rest/api/2/priority/1")
    private String self;
    @JsonProperty
    @Schema(example="red")
    private String statusColor;
    @JsonProperty
    @Schema(example="This is a description of the priority")
    private String description;
    @JsonProperty
    @Schema(example="http://www.example.com/jira/images/icons/priorities/major.png")
    private String iconUrl;
    @JsonProperty
    @Schema(example="Major")
    private String name;
    @JsonProperty
    @Schema(example="1")
    private String id;

    public String getSelf() {
        return this.self;
    }

    public void setSelf(String self) {
        this.self = self;
    }

    public String getStatusColor() {
        return this.statusColor;
    }

    public void setStatusColor(String statusColor) {
        this.statusColor = statusColor;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getIconUrl() {
        return this.iconUrl;
    }

    public void setIconUrl(String iconUrl) {
        this.iconUrl = iconUrl;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public static PriorityJsonBean shortBean(Priority priority, JiraBaseUrls urls) {
        Object iconAbsoluteUrl;
        if (priority == null) {
            return null;
        }
        try {
            iconAbsoluteUrl = new URL(priority.getIconUrl()).toString();
        }
        catch (MalformedURLException e) {
            iconAbsoluteUrl = urls.baseUrl() + priority.getIconUrl();
        }
        PriorityJsonBean bean = new PriorityJsonBean();
        bean.self = urls.restApi2BaseUrl() + "priority/" + JiraUrlCodec.encode(priority.getId());
        bean.name = priority.getNameTranslation();
        bean.id = priority.getId();
        bean.iconUrl = iconAbsoluteUrl;
        return bean;
    }

    public static PriorityJsonBean fullBean(Priority priority, JiraBaseUrls urls) {
        if (priority == null) {
            return null;
        }
        PriorityJsonBean bean = PriorityJsonBean.shortBean(priority, urls);
        bean.statusColor = priority.getStatusColor();
        bean.description = priority.getDescTranslation();
        return bean;
    }

    public static Collection<PriorityJsonBean> shortBeans(Collection<Priority> allowedValues, JiraBaseUrls baseUrls) {
        ArrayList result = Lists.newArrayListWithCapacity((int)allowedValues.size());
        for (Priority from : allowedValues) {
            result.add(PriorityJsonBean.shortBean(from, baseUrls));
        }
        return result;
    }
}

