/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.fields.rest.json.beans;

import com.atlassian.jira.issue.fields.rest.json.beans.JiraBaseUrls;
import com.atlassian.jira.issue.status.category.StatusCategory;
import com.atlassian.jira.util.JiraUrlCodec;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Lists;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.ArrayList;
import java.util.Collection;

@JsonIgnoreProperties(ignoreUnknown=true)
public class StatusCategoryJsonBean {
    @JsonProperty
    @Schema(example="http://localhost:8090/jira/rest/api/2.0/statuscategory/1")
    private String self;
    @JsonProperty
    @Schema(example="1")
    private Long id;
    @JsonProperty
    @Schema(example="new")
    private String key;
    @JsonProperty
    @Schema(example="blue-gray")
    private String colorName;
    @JsonProperty
    @Schema(example="To Do")
    private String name;

    public StatusCategoryJsonBean() {
    }

    public StatusCategoryJsonBean(String self, Long id, String key, String colorName) {
        this(self, id, key, colorName, null);
    }

    public StatusCategoryJsonBean(String self, Long id, String key, String colorName, String name) {
        this.self = self;
        this.id = id;
        this.key = key;
        this.colorName = colorName;
        this.name = name;
    }

    public String self() {
        return this.self;
    }

    public StatusCategoryJsonBean self(String self) {
        return new StatusCategoryJsonBean(self, this.id, this.key, this.colorName, this.name);
    }

    public Long id() {
        return this.id;
    }

    public StatusCategoryJsonBean id(Long id) {
        return new StatusCategoryJsonBean(this.self, id, this.key, this.colorName, this.name);
    }

    public String key() {
        return this.key;
    }

    public StatusCategoryJsonBean key(String key) {
        return new StatusCategoryJsonBean(this.self, this.id, key, this.colorName, this.name);
    }

    public String colorName() {
        return this.colorName;
    }

    public StatusCategoryJsonBean colorName(String colorName) {
        return new StatusCategoryJsonBean(this.self, this.id, this.key, colorName, this.name);
    }

    public String name() {
        return this.name;
    }

    public StatusCategoryJsonBean name(String name) {
        return new StatusCategoryJsonBean(this.self, this.id, this.key, this.colorName, name);
    }

    public static StatusCategoryJsonBean bean(StatusCategory statusCategory, JiraBaseUrls baseUrls) {
        if (null == statusCategory) {
            return null;
        }
        return StatusCategoryJsonBean.bean(baseUrls.restApi2BaseUrl() + "statuscategory/" + JiraUrlCodec.encode(String.valueOf(statusCategory.getId())), statusCategory.getId(), statusCategory.getKey(), statusCategory.getColorName(), statusCategory.getTranslatedName());
    }

    public static StatusCategoryJsonBean bean(String self, Long id, String key, String colorName) {
        return StatusCategoryJsonBean.bean(self, id, key, colorName, null);
    }

    public static StatusCategoryJsonBean bean(String self, Long id, String key, String colorName, String name) {
        return new StatusCategoryJsonBean().self(self).id(id).key(key).colorName(colorName).name(name);
    }

    public static Collection<StatusCategoryJsonBean> beans(Collection<StatusCategory> statusCategories, JiraBaseUrls baseUrls) {
        ArrayList result = Lists.newArrayListWithCapacity((int)statusCategories.size());
        for (StatusCategory statusCategory : statusCategories) {
            result.add(StatusCategoryJsonBean.bean(statusCategory, baseUrls));
        }
        return result;
    }
}

