/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.statistics;

import com.atlassian.jira.issue.comparator.UserCachingComparator;
import com.atlassian.jira.issue.search.SearchRequest;
import com.atlassian.jira.issue.search.SearchRequestAppender;
import com.atlassian.jira.issue.search.constants.UserFieldSearchConstantsWithEmpty;
import com.atlassian.jira.issue.search.util.SearchRequestAddendumBuilder;
import com.atlassian.jira.issue.statistics.StatisticsMapper;
import com.atlassian.jira.jql.builder.JqlClauseBuilder;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.user.util.UserManager;
import com.atlassian.jira.util.dbc.Assertions;
import com.atlassian.query.clause.TerminalClause;
import com.atlassian.query.clause.TerminalClauseImpl;
import com.atlassian.query.operand.EmptyOperand;
import com.atlassian.query.operator.Operator;
import com.google.common.base.Function;
import java.util.Comparator;
import java.util.Locale;

public class UserStatisticsMapper
implements StatisticsMapper<ApplicationUser>,
SearchRequestAppender.Factory<ApplicationUser> {
    private final String clauseName;
    private final String indexedField;
    private final UserResolver userResolver;
    protected final JiraAuthenticationContext jiraAuthenticationContext;

    public UserStatisticsMapper(UserFieldSearchConstantsWithEmpty searchConstants, UserManager userManager, JiraAuthenticationContext jiraAuthenticationContext) {
        this(searchConstants.getJqlClauseNames().getPrimaryName(), searchConstants.getEmptyIndexValue(), searchConstants.getIndexField(), userManager, jiraAuthenticationContext);
    }

    public UserStatisticsMapper(String clauseName, String emptyIndexValue, String indexedField, UserManager userManager, JiraAuthenticationContext jiraAuthenticationContext) {
        this.clauseName = Assertions.notBlank("clauseName", clauseName);
        this.indexedField = Assertions.notBlank("indexedField", indexedField);
        this.userResolver = new UserManagerResolver(userManager, emptyIndexValue);
        this.jiraAuthenticationContext = jiraAuthenticationContext;
    }

    @Override
    public Comparator<ApplicationUser> getComparator() {
        return new UserCachingComparator(this.getLocale());
    }

    @Override
    public boolean isValidValue(ApplicationUser value) {
        return true;
    }

    @Override
    public ApplicationUser getValueFromLuceneField(String documentValue) {
        return (ApplicationUser)this.userResolver.apply(documentValue);
    }

    @Override
    public boolean isFieldAlwaysPartOfAnIssue() {
        return true;
    }

    Locale getLocale() {
        return this.jiraAuthenticationContext.getLocale();
    }

    @Override
    @Deprecated
    public SearchRequest getSearchUrlSuffix(ApplicationUser user, SearchRequest searchRequest) {
        return this.getSearchRequestAppender().appendInclusiveSingleValueClause(user, searchRequest);
    }

    @Override
    public SearchRequestAppender<ApplicationUser> getSearchRequestAppender() {
        return new UserSearchRequestAppender(this.getClauseName());
    }

    protected String getClauseName() {
        return this.clauseName;
    }

    @Override
    public String getDocumentConstant() {
        return this.indexedField;
    }

    TerminalClause getUserClause(String name) {
        return new TerminalClauseImpl(this.clauseName, Operator.EQUALS, name);
    }

    TerminalClause getEmptyUserClause() {
        return new TerminalClauseImpl(this.clauseName, Operator.IS, EmptyOperand.EMPTY);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UserStatisticsMapper that = (UserStatisticsMapper)o;
        if (!this.clauseName.equals(that.clauseName)) {
            return false;
        }
        return this.indexedField.equals(that.indexedField);
    }

    @Override
    public int hashCode() {
        int result = this.clauseName.hashCode();
        result = 31 * result + this.indexedField.hashCode();
        return result;
    }

    static class UserManagerResolver
    implements UserResolver {
        private final UserManager userManager;
        private final String emptyIndexValue;

        public UserManagerResolver(UserManager userManager, String emptyIndexValue) {
            this.userManager = userManager;
            this.emptyIndexValue = emptyIndexValue;
        }

        public ApplicationUser apply(String documentValue) {
            if (this.emptyIndexValue != null && this.emptyIndexValue.equals(documentValue)) {
                return null;
            }
            if (documentValue == null) {
                return null;
            }
            return this.userManager.getUserByKey(documentValue);
        }
    }

    static interface UserResolver
    extends Function<String, ApplicationUser> {
    }

    static class UserSearchRequestAppender
    implements SearchRequestAddendumBuilder.AddendumCallback<ApplicationUser>,
    SearchRequestAppender<ApplicationUser> {
        private final String clauseName;

        public UserSearchRequestAppender(String clauseName) {
            this.clauseName = Assertions.notNull(clauseName);
        }

        @Override
        public SearchRequest appendInclusiveSingleValueClause(ApplicationUser value, SearchRequest searchRequest) {
            return SearchRequestAddendumBuilder.appendAndClause(value, searchRequest, this);
        }

        @Override
        public SearchRequest appendExclusiveMultiValueClause(Iterable<? extends ApplicationUser> values, SearchRequest searchRequest) {
            return SearchRequestAddendumBuilder.appendAndNotClauses(values, searchRequest, this);
        }

        @Override
        public void appendNonNullItem(ApplicationUser user, JqlClauseBuilder clauseBuilder) {
            clauseBuilder.addStringCondition(this.clauseName, user.getName());
        }

        @Override
        public void appendNullItem(JqlClauseBuilder clauseBuilder) {
            clauseBuilder.addEmptyCondition(this.clauseName);
        }
    }
}

