/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.jql.context;

import com.atlassian.jira.issue.comparator.VersionComparator;
import com.atlassian.jira.jql.context.AbstractProjectAttributeClauseContextFactory;
import com.atlassian.jira.jql.context.ClauseContext;
import com.atlassian.jira.jql.context.ClauseContextFactory;
import com.atlassian.jira.jql.context.ClauseContextImpl;
import com.atlassian.jira.jql.context.ProjectIssueTypeContextImpl;
import com.atlassian.jira.jql.operand.JqlOperandResolver;
import com.atlassian.jira.jql.operand.QueryLiteral;
import com.atlassian.jira.jql.operator.OperatorClasses;
import com.atlassian.jira.jql.resolver.VersionIndexInfoResolver;
import com.atlassian.jira.jql.resolver.VersionResolver;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.project.version.Version;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.Predicate;
import com.atlassian.jira.util.dbc.Assertions;
import com.atlassian.query.clause.TerminalClause;
import com.atlassian.query.operator.Operator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class VersionClauseContextFactory
extends AbstractProjectAttributeClauseContextFactory<Version>
implements ClauseContextFactory {
    private final JqlOperandResolver jqlOperandResolver;
    private final VersionResolver versionResolver;

    public VersionClauseContextFactory(JqlOperandResolver jqlOperandResolver, VersionResolver versionResolver, PermissionManager permissionManager) {
        super(new VersionIndexInfoResolver(versionResolver), jqlOperandResolver, permissionManager);
        this.jqlOperandResolver = Assertions.notNull("jqlOperandResolver", jqlOperandResolver);
        this.versionResolver = Assertions.notNull("versionResolver", versionResolver);
    }

    @Override
    ClauseContext getContextFromClause(ApplicationUser searcher, TerminalClause terminalClause) {
        Operator operator = terminalClause.getOperator();
        if (!this.handlesOperator(operator)) {
            return ClauseContextImpl.createGlobalClauseContext();
        }
        List<QueryLiteral> literals = this.jqlOperandResolver.getValues(searcher, terminalClause.getOperand(), terminalClause);
        if (literals == null || literals.isEmpty()) {
            return ClauseContextImpl.createGlobalClauseContext();
        }
        Map<Long, Version> specifiedVersions = literals.stream().filter(literal -> !literal.isEmpty()).flatMap(literal -> this.getIds((QueryLiteral)literal).stream()).map(this.versionResolver::get).collect(Collectors.toMap(Version::getId, Function.identity(), (v1, v2) -> v1));
        if (specifiedVersions.isEmpty()) {
            return ClauseContextImpl.createGlobalClauseContext();
        }
        Set contexts = this.getMatchingVersions(operator, specifiedVersions).map(Version::getProject).distinct().flatMap(project -> this.getContextsForProject(searcher, (Project)project).stream()).collect(Collectors.toCollection(HashSet::new));
        if (literals.stream().anyMatch(QueryLiteral::isEmpty)) {
            contexts.add(ProjectIssueTypeContextImpl.createGlobalContext());
        }
        return new ClauseContextImpl(contexts);
    }

    private Stream<Version> getMatchingVersions(Operator operator, Map<Long, Version> specifiedVersions) {
        if (this.isRelationalOperator(operator)) {
            return specifiedVersions.values().stream().flatMap(version -> this.findAnyMatchingVersion((Version)version, operator).stream());
        }
        if (this.isNegationOperator(operator)) {
            return this.versionResolver.getAll().stream().filter(version -> !specifiedVersions.containsKey(version.getId()));
        }
        return specifiedVersions.values().stream();
    }

    private Optional<Version> findAnyMatchingVersion(Version version, Operator operator) {
        if (operator == Operator.LESS_THAN_EQUALS || operator == Operator.GREATER_THAN_EQUALS) {
            return Optional.of(version);
        }
        List<Version> projectVersions = this.versionResolver.getProjectVersions(version.getProjectId());
        Predicate<Version> versionPredicate = operator.getPredicateForValue(VersionComparator.COMPARATOR, version);
        return projectVersions.stream().filter(versionPredicate::evaluate).findAny();
    }

    private boolean handlesOperator(Operator operator) {
        return OperatorClasses.EQUALITY_OPERATORS_WITH_EMPTY.contains((Object)operator) || OperatorClasses.RELATIONAL_ONLY_OPERATORS.contains((Object)operator);
    }
}

