/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.mail.settings;

import com.atlassian.annotations.Internal;
import com.atlassian.annotations.PublicApi;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.config.properties.JiraProperties;
import com.atlassian.jira.config.properties.JiraSystemProperties;
import com.atlassian.jira.mail.settings.MailSetting;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.google.common.annotations.VisibleForTesting;
import java.util.Date;
import javax.annotation.Nullable;

@PublicApi
public interface MailSettings {
    public Send send();

    public Fetch fetch();

    public static class Fetch {
        @VisibleForTesting
        static final String DISABLED_APPLICATION_PROPERTY = "jira.mail.fetch.disabled";
        private final MailSetting disabledSetting;
        @VisibleForTesting
        static final String LEGACY_DISABLED_SYSTEM_PROPERTY = "atlassian.mail.popdisabled";
        @VisibleForTesting
        static final String DISABLED_SYSTEM_PROPERTY = "atlassian.mail.fetchdisabled";
        private final JiraProperties jiraSystemProperties;

        @Deprecated
        public Fetch(ApplicationProperties applicationProperties) {
            this(applicationProperties, ComponentAccessor.getJiraAuthenticationContext());
        }

        @Deprecated
        public Fetch(ApplicationProperties applicationProperties, JiraAuthenticationContext jiraAuthenticationContext) {
            this(applicationProperties, jiraAuthenticationContext, JiraSystemProperties.getInstance(), null);
        }

        private Fetch(ApplicationProperties applicationProperties, JiraAuthenticationContext jiraAuthenticationContext, JiraProperties jiraSystemProperties) {
            this.jiraSystemProperties = jiraSystemProperties;
            this.disabledSetting = new MailSetting.Builder(applicationProperties, DISABLED_APPLICATION_PROPERTY).withJiraAuthenticationContext(jiraAuthenticationContext).build();
        }

        private Fetch(ApplicationProperties applicationProperties, JiraAuthenticationContext jiraAuthenticationContext, JiraProperties jiraSystemProperties, EventPublisher eventPublisher) {
            this.jiraSystemProperties = jiraSystemProperties;
            this.disabledSetting = new MailSetting.Builder(applicationProperties, DISABLED_APPLICATION_PROPERTY).withEventPublisher(eventPublisher).withJiraAuthenticationContext(jiraAuthenticationContext).build();
        }

        public boolean isEnabled() {
            return !this.isDisabled();
        }

        private boolean getSystemPropertyValue() {
            return this.jiraSystemProperties.getBoolean(LEGACY_DISABLED_SYSTEM_PROPERTY) != false || this.jiraSystemProperties.getBoolean(DISABLED_SYSTEM_PROPERTY) != false;
        }

        public boolean isDisabled() {
            if (this.getSystemPropertyValue()) {
                return true;
            }
            return this.disabledSetting.getValue();
        }

        public boolean isModifiable() {
            return !this.getSystemPropertyValue();
        }

        public boolean enable() {
            if (!this.isModifiable()) {
                return false;
            }
            this.disabledSetting.setValue(false);
            return true;
        }

        public boolean disable() {
            if (!this.isModifiable()) {
                return false;
            }
            this.disabledSetting.setValue(true);
            return true;
        }
    }

    public static class Send {
        @VisibleForTesting
        public static final String DISABLED_APPLICATION_PROPERTY = "jira.mail.send.disabled";
        private final MailSetting disableSetting;
        @VisibleForTesting
        public static final String DISABLED_SYSTEM_PROPERTY_KEY = "atlassian.mail.senddisabled";
        private final JiraProperties jiraSystemProperties;

        private Send(ApplicationProperties applicationProperties, JiraAuthenticationContext jiraAuthenticationContext, JiraProperties jiraSystemProperties) {
            this.jiraSystemProperties = jiraSystemProperties;
            this.disableSetting = new MailSetting.Builder(applicationProperties, DISABLED_APPLICATION_PROPERTY).withJiraAuthenticationContext(jiraAuthenticationContext).build();
        }

        private Send(ApplicationProperties applicationProperties, JiraAuthenticationContext jiraAuthenticationContext, JiraProperties jiraSystemProperties, EventPublisher eventPublisher) {
            this.jiraSystemProperties = jiraSystemProperties;
            this.disableSetting = new MailSetting.Builder(applicationProperties, DISABLED_APPLICATION_PROPERTY).withJiraAuthenticationContext(jiraAuthenticationContext).withEventPublisher(eventPublisher).build();
        }

        public boolean isEnabled() {
            return !this.isDisabled();
        }

        public boolean isDisabled() {
            if (this.jiraSystemProperties.getBoolean(DISABLED_SYSTEM_PROPERTY_KEY).booleanValue()) {
                return true;
            }
            return this.isDisabledViaApplicationProperty();
        }

        public boolean isDisabledViaApplicationProperty() {
            return this.disableSetting.getValue();
        }

        public boolean isModifiable() {
            return this.jiraSystemProperties.getBoolean(DISABLED_SYSTEM_PROPERTY_KEY) == false;
        }

        @Nullable
        public String getModifiedBy() {
            return this.disableSetting.getModifiedBy();
        }

        @Nullable
        public Date getModifiedDate() {
            return this.disableSetting.getModifiedDate();
        }

        public boolean enable() {
            if (!this.isModifiable()) {
                return false;
            }
            this.disableSetting.setValue(false);
            return true;
        }

        public boolean disable() {
            if (!this.isModifiable()) {
                return false;
            }
            this.disableSetting.setValue(true);
            return true;
        }
    }

    @Internal
    public static class AuditLoggingMailSettings
    implements MailSettings {
        private final Send send;
        private final Fetch fetch;

        public AuditLoggingMailSettings(ApplicationProperties applicationProperties, JiraAuthenticationContext jiraAuthenticationContext, JiraProperties jiraSystemProperties, EventPublisher eventPublisher) {
            this.send = new Send(applicationProperties, jiraAuthenticationContext, jiraSystemProperties, eventPublisher);
            this.fetch = new Fetch(applicationProperties, jiraAuthenticationContext, jiraSystemProperties, eventPublisher);
        }

        @Override
        public Send send() {
            return this.send;
        }

        @Override
        public Fetch fetch() {
            return this.fetch;
        }
    }

    @Internal
    public static class DefaultMailSettings
    implements MailSettings {
        private final Send send;
        private final Fetch fetch;

        public DefaultMailSettings(ApplicationProperties applicationProperties, JiraAuthenticationContext jiraAuthenticationContext, JiraProperties jiraSystemProperties) {
            this.send = new Send(applicationProperties, jiraAuthenticationContext, jiraSystemProperties);
            this.fetch = new Fetch(applicationProperties, jiraAuthenticationContext, jiraSystemProperties);
        }

        @Override
        public Send send() {
            return this.send;
        }

        @Override
        public Fetch fetch() {
            return this.fetch;
        }
    }
}

