/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.notification;

import com.atlassian.annotations.PublicApi;
import com.atlassian.jira.notification.EventNotifications;
import com.google.common.collect.ImmutableList;
import java.util.List;

@PublicApi
public final class NotificationScheme {
    private final Long id;
    private final String name;
    private final String description;
    private final List<EventNotifications> eventNotifications;

    public NotificationScheme(Long id, String name, String description, Iterable<EventNotifications> notificationEvent) {
        this.id = id;
        this.name = name;
        this.description = description;
        this.eventNotifications = ImmutableList.copyOf(notificationEvent);
    }

    public Long getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public List<EventNotifications> getEventNotifications() {
        return this.eventNotifications;
    }

    public String getDescription() {
        return this.description;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NotificationScheme that = (NotificationScheme)o;
        if (this.description != null ? !this.description.equals(that.description) : that.description != null) {
            return false;
        }
        if (this.id != null ? !this.id.equals(that.id) : that.id != null) {
            return false;
        }
        if (this.name != null ? !this.name.equals(that.name) : that.name != null) {
            return false;
        }
        return !(this.eventNotifications != null ? !this.eventNotifications.equals(that.eventNotifications) : that.eventNotifications != null);
    }

    public int hashCode() {
        int result = this.id != null ? this.id.hashCode() : 0;
        result = 31 * result + (this.name != null ? this.name.hashCode() : 0);
        result = 31 * result + (this.description != null ? this.description.hashCode() : 0);
        result = 31 * result + (this.eventNotifications != null ? this.eventNotifications.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "NotificationScheme{id=" + this.id + ", name='" + this.name + "', description='" + this.description + "', eventNotifications=" + this.eventNotifications + "}";
    }
}

