/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugin.issuetabpanel;

import com.atlassian.jira.plugin.issuetabpanel.IssueAction;
import com.atlassian.jira.plugin.issuetabpanel.Page;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

public class DefaultPage<T>
implements Page<T> {
    private final List<T> pageContents;
    private final boolean isFirstPage;
    private final boolean isLastPage;

    private DefaultPage(List<T> pageContents, boolean isFirstPage, boolean isLastPage) {
        this.pageContents = ImmutableList.copyOf((Collection)Objects.requireNonNull(pageContents));
        this.isFirstPage = isFirstPage;
        this.isLastPage = isLastPage;
    }

    public static <T> DefaultPage<T> first(Collection<T> coll) {
        return new DefaultPage<T>(new ArrayList<T>(coll), true, false);
    }

    public static <T> DefaultPage<T> last(Collection<T> coll) {
        return new DefaultPage<T>(new ArrayList<T>(coll), false, true);
    }

    public static <T> DefaultPage<T> only(Collection<T> coll) {
        return new DefaultPage<T>(new ArrayList<T>(coll), true, true);
    }

    public static <T> DefaultPage<T> nth(Collection<T> coll) {
        return new DefaultPage<T>(new ArrayList<T>(coll), false, false);
    }

    public static Page<IssueAction> empty() {
        return new DefaultPage<IssueAction>(Collections.emptyList(), true, true);
    }

    @Override
    public List<T> getPageContents() {
        return ImmutableList.copyOf(this.pageContents);
    }

    @Override
    public boolean isFirstPage() {
        return this.isFirstPage;
    }

    @Override
    public boolean isLastPage() {
        return this.isLastPage;
    }

    public String toString() {
        return this.pageContents.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DefaultPage that = (DefaultPage)o;
        return this.isFirstPage == that.isFirstPage && this.isLastPage == that.isLastPage && this.pageContents.equals(that.pageContents);
    }

    public int hashCode() {
        return Objects.hash(this.pageContents, this.isFirstPage, this.isLastPage);
    }
}

