/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugin.issuetabpanel;

import com.atlassian.annotations.ExperimentalApi;
import com.atlassian.annotations.Internal;
import com.atlassian.annotations.PublicApi;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.user.ApplicationUser;
import java.util.Date;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;

@PublicApi
@Immutable
public final class GetActionsRequest {
    private final Issue issue;
    private final ApplicationUser remoteUser;
    private final boolean asynchronous;
    private final boolean showAll;
    private final String focusId;
    private final Batching batch;
    public static final int DEFAULT_INITIAL_LIMIT = 10;
    public static final int DEFAULT_LIMIT = 100;
    public static final int DEFAULT_LIMIT_FOR_FOCUSED_ITEM = 50;
    @ExperimentalApi
    public static final Batching DEFAULT_BATCHING = new Batching(FetchMode.FROM_NEWEST, null, 100);

    @Internal
    public GetActionsRequest(@Nonnull Issue issue, @Nullable ApplicationUser remoteUser, boolean asynchronous, boolean showAll, @Nullable String focusId) {
        this(issue, remoteUser, asynchronous, showAll, focusId, DEFAULT_BATCHING);
    }

    @Internal
    public GetActionsRequest(@Nonnull Issue issue, @Nullable ApplicationUser remoteUser, boolean asynchronous, boolean showAll, @Nullable String focusId, @Nonnull Batching batch) {
        this.issue = Objects.requireNonNull(issue);
        this.remoteUser = remoteUser;
        this.asynchronous = asynchronous;
        this.showAll = showAll;
        this.focusId = focusId;
        this.batch = Objects.requireNonNull(batch);
    }

    @Nonnull
    public Issue issue() {
        return this.issue;
    }

    @Nullable
    public ApplicationUser remoteUser() {
        return this.remoteUser;
    }

    public boolean isAnonymous() {
        return this.remoteUser() == null;
    }

    public boolean isAsynchronous() {
        return this.asynchronous;
    }

    @Nullable
    public ApplicationUser loggedInUser() {
        return this.remoteUser;
    }

    public boolean isShowAll() {
        return this.showAll;
    }

    @Nullable
    public String getFocusId() {
        return this.focusId;
    }

    @ExperimentalApi
    @Nonnull
    public Batching batching() {
        return this.batch;
    }

    public boolean isValidShowAllRequest() {
        return this.isShowAll() && this.isAsynchronous();
    }

    @ExperimentalApi
    public static class Batching {
        private final FetchMode fetchMode;
        private final Date fromDate;
        private final int limit;
        private final boolean returnOldest;

        public Batching(@Nonnull FetchMode fetchMode, @Nullable Date fromDate, int limit) {
            this(fetchMode, fromDate, limit, false);
        }

        public Batching(@Nonnull FetchMode fetchMode, @Nullable Date fromDate, int limit, boolean returnOldest) {
            if ((fetchMode == FetchMode.OLDER_THAN_DATE || fetchMode == FetchMode.NEWER_THAN_DATE) && fromDate == null) {
                throw new IllegalArgumentException("When searching relative to a date, the fromDate field must not be null");
            }
            this.returnOldest = returnOldest;
            this.fetchMode = Objects.requireNonNull(fetchMode);
            this.fromDate = fromDate;
            this.limit = limit;
        }

        public static Batching searchFromOldest() {
            return new Batching(FetchMode.FROM_OLDEST, null, 100);
        }

        public static Batching searchFromOldest(int limit) {
            return new Batching(FetchMode.FROM_OLDEST, null, limit);
        }

        public static Batching searchFromNewest() {
            return new Batching(FetchMode.FROM_NEWEST, null, 100);
        }

        public static Batching searchFromNewest(int limit) {
            return new Batching(FetchMode.FROM_NEWEST, null, limit);
        }

        public static Batching searchOlderThanDate(Date date) {
            return new Batching(FetchMode.OLDER_THAN_DATE, date, 100);
        }

        public static Batching searchOlderThanDate(Date date, int limit) {
            return new Batching(FetchMode.OLDER_THAN_DATE, date, limit);
        }

        public static Batching searchNewerThanDate(Date date) {
            return new Batching(FetchMode.NEWER_THAN_DATE, date, 100);
        }

        public static Batching searchNewerThanDate(Date date, int limit) {
            return new Batching(FetchMode.NEWER_THAN_DATE, date, limit);
        }

        @Nonnull
        public FetchMode fetchMode() {
            return this.fetchMode;
        }

        @Nullable
        public Date fromDate() {
            return this.fromDate;
        }

        public int limit() {
            return this.limit;
        }

        public boolean returnOldest() {
            return this.returnOldest;
        }
    }

    public static enum FetchMode {
        OLDER_THAN_DATE,
        NEWER_THAN_DATE,
        FROM_OLDEST,
        FROM_NEWEST;

    }

    public static class GetActionRequestBuilder
    implements GetActionRequestIssue,
    GetActionRequestApplicationUser,
    GetActionRequestAsync,
    GetActionRequestShowAll,
    GetActionRequestBatch,
    GetActionRequestCreator {
        private Issue issue;
        private ApplicationUser remoteUser;
        private boolean asynchronous;
        private boolean showAll;
        private String focusId;
        private Batching batching;

        private GetActionRequestBuilder() {
        }

        public static GetActionRequestIssue builder() {
            return new GetActionRequestBuilder();
        }

        @Override
        public GetActionRequestApplicationUser issue(Issue issue) {
            this.issue = issue;
            return this;
        }

        @Override
        public GetActionRequestAsync applicationUser(ApplicationUser applicationUser) {
            this.remoteUser = applicationUser;
            return this;
        }

        @Override
        public GetActionRequestShowAll asynchronous(boolean async) {
            this.asynchronous = async;
            return this;
        }

        @Override
        public GetActionRequestBatch showAll(boolean showAll) {
            this.showAll = showAll;
            return this;
        }

        @Override
        public GetActionRequestCreator focusId(String focusId) {
            this.focusId = focusId;
            return this;
        }

        @Override
        public GetActionRequestCreator batch(Batching batching) {
            this.batching = batching;
            return this;
        }

        @Override
        public GetActionRequestCreator defaultBatch() {
            this.batching = DEFAULT_BATCHING;
            return this;
        }

        @Override
        public GetActionsRequest build() {
            return new GetActionsRequest(this.issue, this.remoteUser, this.asynchronous, this.showAll, this.focusId, this.batching);
        }
    }

    public static interface GetActionRequestCreator {
        public GetActionRequestCreator focusId(String var1);

        public GetActionsRequest build();
    }

    public static interface GetActionRequestBatch {
        public GetActionRequestCreator batch(Batching var1);

        public GetActionRequestCreator defaultBatch();
    }

    public static interface GetActionRequestShowAll {
        public GetActionRequestBatch showAll(boolean var1);
    }

    public static interface GetActionRequestAsync {
        public GetActionRequestShowAll asynchronous(boolean var1);
    }

    public static interface GetActionRequestApplicationUser {
        public GetActionRequestAsync applicationUser(ApplicationUser var1);
    }

    public static interface GetActionRequestIssue {
        public GetActionRequestApplicationUser issue(Issue var1);
    }
}

