/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugin.util;

import com.atlassian.plugin.module.Element;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ModuleDescriptorXMLUtils {
    private static final Logger log = LoggerFactory.getLogger(ModuleDescriptorXMLUtils.class);
    public static final int DEFAULT_ORDER = Integer.MAX_VALUE;

    private ModuleDescriptorXMLUtils() {
    }

    public static int getOrder(Element element) {
        int order = Integer.MAX_VALUE;
        if (element.element("order") != null) {
            try {
                order = Integer.parseInt(element.element("order").getTextTrim());
            }
            catch (NumberFormatException e) {
                log.warn("Invalid order specified: " + element.element("order").getTextTrim() + ". Should be an integer.", (Throwable)e);
            }
        }
        return order;
    }

    public static Optional<String> getClass(Element element) {
        return Optional.ofNullable(element.attributeValue("class"));
    }
}

