/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.search.field;

import com.atlassian.annotations.Internal;
import com.atlassian.jira.search.Document;
import com.atlassian.jira.search.FieldVisitor;
import com.atlassian.jira.search.field.AbstractField;
import com.atlassian.jira.search.field.FieldOption;
import com.atlassian.jira.search.field.FieldValue;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

@Internal
public final class AnalyzedTextField
extends AbstractField {
    private final boolean concatenated;

    public AnalyzedTextField(String name) {
        this(name, false, FieldOption.INDEXED, FieldOption.STORED);
    }

    public AnalyzedTextField(String name, boolean concatenated, FieldOption ... options) {
        this(name, concatenated, List.of(options));
    }

    public AnalyzedTextField(String name, boolean concatenated, Collection<FieldOption> options) {
        super(name, EnumSet.of(FieldOption.INDEXED, ((Collection)Optional.ofNullable(options).orElse(Collections.emptyList())).toArray(new FieldOption[0])));
        this.concatenated = concatenated;
    }

    @Override
    public <T> Optional<T> accept(FieldVisitor<T> visitor) {
        return visitor.visit(this);
    }

    public boolean isConcatenated() {
        return this.concatenated;
    }

    public FieldValue create(String value) {
        return new FieldValue(this, value);
    }

    public List<String> get(Document doc) {
        return doc.getValues(this);
    }

    @Override
    public boolean equals(Object o) {
        return super.equals(o) && ((AnalyzedTextField)o).concatenated == this.concatenated;
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.name(), this.isConcatenated(), this.getOptions());
    }

    @Override
    protected String propsToString() {
        return super.propsToString() + ",concatenated=" + this.concatenated;
    }
}

