/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.search.field;

import com.atlassian.annotations.Internal;
import com.atlassian.jira.search.Field;
import com.atlassian.jira.util.dbc.Assertions;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;

@Internal
public class FieldValue {
    private final Field field;
    private final Object value;

    public FieldValue(Field field, @Nullable Object value) {
        this.field = Objects.requireNonNull(field, "field");
        this.value = value;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FieldValue that = (FieldValue)o;
        return Objects.equals(this.field, that.field) && Objects.equals(this.value, that.value);
    }

    public Field getField() {
        return this.field;
    }

    public <T> Optional<T> getValue(Class<T> type) {
        Assertions.notNull("type", type);
        return Optional.ofNullable(type.cast(this.value));
    }

    public Optional<Object> getValue() {
        return Optional.ofNullable(this.value);
    }

    public int hashCode() {
        return Objects.hash(this.field, this.value);
    }
}

