/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.search.query;

import com.atlassian.annotations.Internal;
import com.atlassian.jira.search.Query;
import com.atlassian.jira.search.query.BoostQuery;
import java.util.Objects;

@Internal
public final class DefaultBoostQuery
implements BoostQuery {
    private final Query query;
    private final float boost;

    public DefaultBoostQuery(Query query, float boost) {
        this.query = Objects.requireNonNull(query);
        this.boost = boost;
    }

    @Override
    public Query query() {
        return this.query;
    }

    @Override
    public float boost() {
        return this.boost;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        DefaultBoostQuery that = (DefaultBoostQuery)obj;
        return Objects.equals(this.query, that.query) && Float.floatToIntBits(this.boost) == Float.floatToIntBits(that.boost);
    }

    public int hashCode() {
        return Objects.hash(this.query, Float.valueOf(this.boost));
    }

    public String toString() {
        return "DefaultBoostQuery[query=" + this.query + ", boost=" + this.boost + "]";
    }
}

