/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.search.request;

import com.atlassian.annotations.Internal;
import com.google.common.base.Preconditions;
import java.util.Objects;

@Internal
public class PageRequest {
    private final int limit;
    private final long start;

    public PageRequest(long start, int limit) {
        Preconditions.checkArgument((start >= 0L ? 1 : 0) != 0, (Object)"start must be >= 0");
        Preconditions.checkArgument((limit > 0 ? 1 : 0) != 0, (Object)"limit must be > 0");
        this.limit = limit;
        this.start = start;
    }

    public static PageRequest of(long start, int limit) {
        return new PageRequest(start, limit);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PageRequest that = (PageRequest)o;
        return this.limit == that.limit && this.start == that.start;
    }

    public int getLimit() {
        return this.limit;
    }

    public long getStart() {
        return this.start;
    }

    public int hashCode() {
        return Objects.hash(this.limit, this.start);
    }
}

