/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.task.context;

import com.atlassian.annotations.Internal;
import com.atlassian.jira.task.TaskProgressSink;
import com.atlassian.jira.task.context.Sink;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.util.dbc.Assertions;
import org.apache.commons.lang3.StringUtils;

@Internal
class TaskProgressPercentageContextSink
implements Sink {
    private final I18nHelper i18nHelper;
    private final TaskProgressSink progressSink;
    private volatile String currentSubTask;
    private final String uiMessageKeyPercentage;
    private final String uiMessageKeyCurrent;

    TaskProgressPercentageContextSink(I18nHelper i18nHelper, TaskProgressSink progressSink, String uiMessageKeyPercentage, String uiMessageKeyCurrent) {
        Assertions.notNull("i18nHelper", i18nHelper);
        Assertions.notNull("progressSink", progressSink);
        this.i18nHelper = i18nHelper;
        this.progressSink = progressSink;
        this.uiMessageKeyPercentage = uiMessageKeyPercentage;
        this.uiMessageKeyCurrent = uiMessageKeyCurrent;
    }

    @Override
    public void setName(String currentSubTask) {
        this.currentSubTask = currentSubTask;
    }

    @Override
    public void updateProgress(int progress) {
        String message = this.i18nHelper.getText(this.uiMessageKeyPercentage, progress);
        String sub = StringUtils.isBlank((CharSequence)this.currentSubTask) || StringUtils.isBlank((CharSequence)this.uiMessageKeyCurrent) ? null : this.i18nHelper.getText(this.uiMessageKeyCurrent, this.currentSubTask);
        this.progressSink.makeProgress(progress, sub, message);
    }
}

