/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.workflow;

import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.issue.fields.screen.FieldScreen;
import com.atlassian.jira.issue.fields.screen.FieldScreenManager;
import com.google.common.collect.ImmutableMap;
import com.opensymphony.util.TextUtils;
import com.opensymphony.workflow.loader.ActionDescriptor;
import java.util.Map;
import java.util.Optional;

public class WorkflowActionsBean {
    public static final long VIEW_COMMENTASSIGN_ID = 2L;
    public static final long VIEW_RESOLVE_ID = 3L;
    private static final Map<String, Long> screensForViews = ImmutableMap.of((Object)"commentassign", (Object)2L, (Object)"resolveissue", (Object)3L);
    private static final Map<String, String> availableViews = ImmutableMap.of((Object)"", (Object)"No view for transition", (Object)"commentassign", (Object)"Add comment and assign", (Object)"resolveissue", (Object)"Add comment, assign and set resolution");
    private FieldScreenManager fieldScreenManager;

    public Map<String, String> getAvailableViews() {
        return availableViews;
    }

    public String getSelectedView() {
        return "commentassign";
    }

    public FieldScreen getFieldScreenForView(ActionDescriptor actionDescriptor) {
        Optional<Long> fieldScreenIdForView = this.getFieldScreenIdForView(actionDescriptor);
        if (!fieldScreenIdForView.isPresent()) {
            return null;
        }
        FieldScreen fieldScreen = this.getFieldScreenManager().getFieldScreen(fieldScreenIdForView.get());
        if (fieldScreen != null) {
            return fieldScreen;
        }
        throw new IllegalArgumentException("Cannot find Screen with id '" + fieldScreenIdForView.get() + "'.");
    }

    public Optional<Long> getFieldScreenIdForView(ActionDescriptor actionDescriptor) {
        String view = actionDescriptor.getView();
        if (TextUtils.stringSet((String)view)) {
            if (screensForViews.containsKey(view)) {
                return Optional.ofNullable(screensForViews.get(view));
            }
            if (actionDescriptor.getMetaAttributes().containsKey("jira.fieldscreen.id")) {
                return Optional.of(new Long((String)actionDescriptor.getMetaAttributes().get("jira.fieldscreen.id")));
            }
            throw new IllegalArgumentException("Unknown workflow view '" + view + "', or cannot find attribute 'jira.fieldscreen.id' for workflow action '" + actionDescriptor.getId() + "'.");
        }
        return Optional.empty();
    }

    private FieldScreenManager getFieldScreenManager() {
        if (this.fieldScreenManager == null) {
            this.fieldScreenManager = ComponentAccessor.getFieldScreenManager();
        }
        return this.fieldScreenManager;
    }
}

