/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.event;

import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.event.AbstractEvent;
import com.atlassian.jira.permission.GlobalPermissionKey;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.security.GlobalPermissionManager;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.workflow.JiraWorkflow;
import com.atlassian.jira.workflow.ProjectWorkflowSchemeHelper;
import com.google.common.base.Preconditions;
import java.util.List;
import javax.annotation.Nonnull;

public abstract class AbstractWorkflowEvent
extends AbstractEvent {
    private final JiraWorkflow workflow;
    private final boolean isAdmin;
    private final boolean isSysAdmin;
    private final boolean isolated;
    private final boolean hasExtPermission;
    private final Long projectId;

    public AbstractWorkflowEvent(@Nonnull JiraWorkflow workflow) {
        Preconditions.checkNotNull((Object)workflow, (Object)"workflow must not be null");
        this.workflow = workflow;
        ApplicationUser user = ComponentAccessor.getJiraAuthenticationContext().getLoggedInUser();
        GlobalPermissionManager globalPermissionManager = ComponentAccessor.getGlobalPermissionManager();
        this.isAdmin = globalPermissionManager.hasPermission(GlobalPermissionKey.ADMINISTER, user);
        this.isSysAdmin = globalPermissionManager.hasPermission(GlobalPermissionKey.SYSTEM_ADMIN, user);
        ProjectWorkflowSchemeHelper projectWorkflowSchemeHelper = ComponentAccessor.getComponent(ProjectWorkflowSchemeHelper.class);
        this.isolated = projectWorkflowSchemeHelper.isWorkflowIsolated(workflow.getName());
        if (this.isolated) {
            List<Project> workflowUsedInProjects = projectWorkflowSchemeHelper.getAllProjectsForWorkflow(workflow.getName());
            if (workflowUsedInProjects.size() == 1) {
                Project workflowProject = (Project)workflowUsedInProjects.iterator().next();
                this.projectId = workflowProject.getId();
                this.hasExtPermission = ComponentAccessor.getPermissionSchemeManager().hasExtendedProjectAdministration(workflowProject);
            } else {
                this.projectId = null;
                this.hasExtPermission = false;
            }
        } else {
            this.projectId = null;
            this.hasExtPermission = false;
        }
    }

    public JiraWorkflow getWorkflow() {
        return this.workflow;
    }

    public int getWorkflowHash() {
        return this.workflow.getName().hashCode();
    }

    public boolean getIsAdmin() {
        return this.isAdmin;
    }

    public boolean getIsSysAdmin() {
        return this.isSysAdmin;
    }

    public boolean getIsolated() {
        return this.isolated;
    }

    public boolean isHasExtPermission() {
        return this.hasExtPermission;
    }

    public Long getProjectId() {
        return this.projectId;
    }
}

