/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.statistics;

import com.atlassian.jira.issue.label.Label;
import com.atlassian.jira.issue.label.LabelComparator;
import com.atlassian.jira.issue.search.SearchRequest;
import com.atlassian.jira.issue.search.SearchRequestAppender;
import com.atlassian.jira.issue.search.constants.SystemSearchConstants;
import com.atlassian.jira.issue.search.util.SearchRequestAddendumBuilder;
import com.atlassian.jira.issue.statistics.StatisticsMapper;
import com.atlassian.jira.jql.builder.JqlClauseBuilder;
import com.atlassian.jira.util.dbc.Assertions;
import java.util.Comparator;
import org.apache.commons.lang3.StringUtils;

public class LabelsStatisticsMapper
implements StatisticsMapper,
SearchRequestAppender.Factory {
    private final String clauseName;
    private final String indexedField;
    private final boolean includeEmpty;

    public LabelsStatisticsMapper(boolean includeEmpty) {
        this(SystemSearchConstants.forLabels().getJqlClauseNames().getPrimaryName(), SystemSearchConstants.forLabels().getIndexField(), includeEmpty);
    }

    public LabelsStatisticsMapper(String clauseName, String indexedField, boolean includeEmpty) {
        this.clauseName = Assertions.notBlank("clauseName", clauseName);
        this.indexedField = Assertions.notBlank("indexedField", indexedField);
        this.includeEmpty = includeEmpty;
    }

    @Override
    public Comparator getComparator() {
        return LabelComparator.INSTANCE;
    }

    public boolean isValidValue(Object value) {
        return value != null || this.includeEmpty;
    }

    @Override
    public Object getValueFromLuceneField(String documentValue) {
        if (StringUtils.isEmpty((CharSequence)documentValue) || "<EMPTY>".equals(documentValue)) {
            return null;
        }
        return new Label(null, null, documentValue);
    }

    @Override
    public boolean isFieldAlwaysPartOfAnIssue() {
        return true;
    }

    @Deprecated
    public SearchRequest getSearchUrlSuffix(Object value, SearchRequest searchRequest) {
        return this.getSearchRequestAppender().appendInclusiveSingleValueClause(value, searchRequest);
    }

    public SearchRequestAppender getSearchRequestAppender() {
        return new LabelsSearchRequestAppender(this.getClauseName());
    }

    protected String getClauseName() {
        return this.clauseName;
    }

    @Override
    public String getDocumentConstant() {
        return this.indexedField;
    }

    static class LabelsSearchRequestAppender
    implements SearchRequestAddendumBuilder.AddendumCallback<Label>,
    SearchRequestAppender<Label> {
        private final String clauseName;

        public LabelsSearchRequestAppender(String clauseName) {
            this.clauseName = Assertions.notNull(clauseName);
        }

        @Override
        public void appendNonNullItem(Label label, JqlClauseBuilder clauseBuilder) {
            clauseBuilder.labels(label.getLabel());
        }

        @Override
        public void appendNullItem(JqlClauseBuilder clauseBuilder) {
            clauseBuilder.addEmptyCondition(this.clauseName);
        }

        @Override
        public SearchRequest appendInclusiveSingleValueClause(Label value, SearchRequest searchRequest) {
            return SearchRequestAddendumBuilder.appendAndClause(value, searchRequest, this);
        }

        @Override
        public SearchRequest appendExclusiveMultiValueClause(Iterable values, SearchRequest searchRequest) {
            return null;
        }
    }
}

