/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.util;

import com.atlassian.annotations.PublicApi;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.changehistory.metadata.HistoryMetadata;
import com.atlassian.jira.issue.comments.Comment;
import com.atlassian.jira.issue.history.ChangeItemBean;
import com.atlassian.jira.issue.worklog.Worklog;
import com.atlassian.jira.user.ApplicationUser;
import com.google.common.base.Objects;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.codehaus.jackson.JsonNode;
import org.ofbiz.core.entity.GenericValue;

@PublicApi
public class IssueUpdateBean {
    private final GenericValue changedIssue;
    private final GenericValue originalIssue;
    private final Long eventTypeId;
    private final ApplicationUser user;
    private final boolean sendMail;
    private Worklog worklog;
    private boolean dispatchEvent = true;
    private Comment comment;
    private Map params = new HashMap();
    Collection<ChangeItemBean> changeItems;
    private boolean subtasksUpdated;
    private HistoryMetadata historyMetadata;
    private Map<String, JsonNode> properties = new HashMap<String, JsonNode>();

    public Worklog getWorklog() {
        return this.worklog;
    }

    public void setWorklog(Worklog worklog) {
        this.worklog = worklog;
    }

    public IssueUpdateBean(Issue changedIssue, Issue originalIssue, Long eventTypeId, ApplicationUser user) {
        this(changedIssue, originalIssue, eventTypeId, user, true, false);
    }

    public IssueUpdateBean(GenericValue changedIssue, GenericValue originalIssue, Long eventTypeId, ApplicationUser user) {
        this(changedIssue, originalIssue, eventTypeId, user, true, false);
    }

    public IssueUpdateBean(GenericValue changedIssue, GenericValue originalIssue, Long eventTypeId, ApplicationUser user, boolean sendMail, boolean subtasksUpdated) {
        this.changedIssue = changedIssue;
        this.originalIssue = originalIssue;
        this.eventTypeId = eventTypeId;
        this.user = user;
        this.sendMail = sendMail;
        this.subtasksUpdated = subtasksUpdated;
    }

    public IssueUpdateBean(Issue changedIssue, Issue originalIssue, Long eventTypeId, ApplicationUser user, boolean sendMail, boolean subtasksUpdated) {
        this(changedIssue.getGenericValue(), originalIssue.getGenericValue(), eventTypeId, user, sendMail, subtasksUpdated);
    }

    public boolean isDispatchEvent() {
        return this.dispatchEvent;
    }

    public void setDispatchEvent(boolean dispatchEvent) {
        this.dispatchEvent = dispatchEvent;
    }

    public Comment getComment() {
        return this.comment;
    }

    public void setComment(Comment comment) {
        this.comment = comment;
    }

    public Map getParams() {
        return this.params;
    }

    public void setParams(Map params) {
        this.params = params;
    }

    public Collection<ChangeItemBean> getChangeItems() {
        return this.changeItems;
    }

    public void setChangeItems(Collection<ChangeItemBean> changeItems) {
        this.changeItems = changeItems;
    }

    public GenericValue getChangedIssue() {
        return this.changedIssue;
    }

    @Deprecated
    public ApplicationUser getUser() {
        return this.user;
    }

    public ApplicationUser getApplicationUser() {
        return this.user;
    }

    public GenericValue getOriginalIssue() {
        return this.originalIssue;
    }

    public Long getEventTypeId() {
        return this.eventTypeId;
    }

    public boolean isSendMail() {
        return this.sendMail;
    }

    public boolean isSubtasksUpdated() {
        return this.subtasksUpdated;
    }

    public HistoryMetadata getHistoryMetadata() {
        return this.historyMetadata;
    }

    public void setHistoryMetadata(HistoryMetadata historyMetadata) {
        this.historyMetadata = historyMetadata;
    }

    public Map<String, JsonNode> getProperties() {
        return this.properties;
    }

    public void addProperties(Map<String, JsonNode> properties) {
        this.properties.putAll(properties);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof IssueUpdateBean)) {
            return false;
        }
        IssueUpdateBean issueUpdateBean = (IssueUpdateBean)o;
        if (this.dispatchEvent != issueUpdateBean.dispatchEvent) {
            return false;
        }
        if (this.eventTypeId == null && issueUpdateBean.getEventTypeId() != null || this.eventTypeId != null && !this.eventTypeId.equals(issueUpdateBean.getEventTypeId())) {
            return false;
        }
        if (this.changeItems != null ? !this.changeItems.equals(issueUpdateBean.changeItems) : issueUpdateBean.changeItems != null) {
            return false;
        }
        if (this.changedIssue != null ? !this.changedIssue.equals((Object)issueUpdateBean.changedIssue) : issueUpdateBean.changedIssue != null) {
            return false;
        }
        if (this.comment != null ? !this.comment.equals(issueUpdateBean.comment) : issueUpdateBean.comment != null) {
            return false;
        }
        if (this.originalIssue != null ? !this.originalIssue.equals((Object)issueUpdateBean.originalIssue) : issueUpdateBean.originalIssue != null) {
            return false;
        }
        if (this.params != null ? !this.params.equals(issueUpdateBean.params) : issueUpdateBean.params != null) {
            return false;
        }
        if (this.user != null ? !this.user.equals(issueUpdateBean.user) : issueUpdateBean.user != null) {
            return false;
        }
        if (this.eventTypeId != null ? !this.eventTypeId.equals(issueUpdateBean.eventTypeId) : issueUpdateBean.eventTypeId != null) {
            return false;
        }
        if (this.sendMail != issueUpdateBean.sendMail) {
            return false;
        }
        if (this.subtasksUpdated != issueUpdateBean.subtasksUpdated) {
            return false;
        }
        return Objects.equal((Object)this.historyMetadata, (Object)issueUpdateBean.historyMetadata);
    }

    public int hashCode() {
        int result = this.changedIssue != null ? this.changedIssue.hashCode() : 0;
        result = 29 * result + (this.originalIssue != null ? this.originalIssue.hashCode() : 0);
        result = 29 * result + (this.eventTypeId != null ? this.eventTypeId.hashCode() : 0);
        result = 29 * result + (this.user != null ? this.user.hashCode() : 0);
        result = 29 * result + (this.dispatchEvent ? 1 : 0);
        result = 29 * result + (this.sendMail ? 1 : 0);
        result = 29 * result + (this.comment != null ? this.comment.hashCode() : 0);
        result = 29 * result + (this.params != null ? this.params.hashCode() : 0);
        result = 29 * result + (this.changeItems != null ? this.changeItems.hashCode() : 0);
        result = 29 * result + (this.subtasksUpdated ? 1 : 0);
        result = 29 * result + Objects.hashCode((Object[])new Object[]{this.historyMetadata});
        return result;
    }
}

