/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.jql.values;

import com.atlassian.jira.bc.JiraServiceContextImpl;
import com.atlassian.jira.bc.user.search.UserSearchService;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.jql.values.ClauseValuesGenerator;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.EmailFormatter;
import java.util.ArrayList;
import java.util.List;

public class UserClauseValuesGenerator
implements ClauseValuesGenerator {
    private final UserSearchService userSearchService;
    private final EmailFormatter emailFormatter;

    @Deprecated
    public UserClauseValuesGenerator(UserSearchService userSearchService) {
        this(userSearchService, ComponentAccessor.getComponent(EmailFormatter.class));
    }

    public UserClauseValuesGenerator(UserSearchService userSearchService, EmailFormatter emailFormatter) {
        this.userSearchService = userSearchService;
        this.emailFormatter = emailFormatter;
    }

    @Override
    public ClauseValuesGenerator.Results getPossibleValues(ApplicationUser searcher, String jqlClauseName, String valuePrefix, int maxNumResults) {
        ArrayList<ClauseValuesGenerator.Result> userValues = new ArrayList<ClauseValuesGenerator.Result>();
        JiraServiceContextImpl serviceContext = new JiraServiceContextImpl(searcher);
        if (this.userSearchService.canPerformAjaxSearch(serviceContext)) {
            List<ApplicationUser> users = this.userSearchService.findUsersAllowEmptyQuery(serviceContext, valuePrefix);
            for (ApplicationUser user : users) {
                if (userValues.size() == maxNumResults) break;
                ClauseValuesGenerator.Result userValue = new ClauseValuesGenerator.Result(user.getName(), this.assembleDisplayNameParts(user, searcher));
                userValues.add(userValue);
            }
        }
        return new ClauseValuesGenerator.Results(userValues);
    }

    private String[] assembleDisplayNameParts(ApplicationUser user, ApplicationUser searcher) {
        String fullName = user.getDisplayName();
        String name = user.getName();
        String email = this.emailFormatter.formatEmail(user, searcher);
        if (email != null) {
            return new String[]{fullName, "- " + email, " (" + name + ")"};
        }
        return new String[]{fullName, " (" + name + ")"};
    }
}

